# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.message import Message
from utils.common.fic_base import StepBaseInterface
from utils.business.project_condition_utils import get_project_condition_boolean
from plugins.DistributedStorage.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.implement.tc_install_node import InstallNode


class InstallNodeIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.params = ParamsGain(project_id, pod_id, self.db)
        if get_project_condition_boolean(self.project_id, 'TenantStorNewPool|TenantStorNewNode'):
            fs_args = self.params.get_business_separate_expand_fusionstorage_args_while_new_pool_or_new_node()
        else:
            fs_args = self.params.get_business_separate_args()
        self.fs_args = fs_args

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        return InstallNode(project_id, pod_id, self.fs_args).run()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return InstallNode(project_id, pod_id, self.fs_args).retry_install_node()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
