# -*-coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import os


class PublicItems:
    @staticmethod
    def get_post_script(cpu_arch):
        x86_post_script = 'sed -i "s/chage -d 0/chage -d `date +%Y-%m-%d`/g" /etc/EulerOS_init.sh; ' \
                          'sed -i "s/chage -d 0/chage -d `date +%Y-%m-%d`/g" ' \
                          '/opt/reinforce_os/reinforce_script/014.Add_and_Modify_User.sh; ' \
                          'if [ -f /etc/EulerOS_init.sh ];then sh /etc/EulerOS_init.sh; ' \
                          'else sh /opt/reinforce_os/reinforce_os.sh install; fi; chage -d `date +%Y-%m-%d` root'
        # 1823 网卡安装完驱动后需要手动加载驱动，才能识别网口
        arm_post_script = x86_post_script + ';modprobe hisdk3;modprobe hinic3'
        post_script = {
            "X86": x86_post_script,
            "ARM": arm_post_script
        }
        return post_script.get(cpu_arch)


class X86Euler:
    @staticmethod
    def euler_install_packages():
        file_name = "rpmlist_x86"
        file_path = os.path.realpath(__file__ + '../../' + file_name)
        with open(file_path, 'r') as f:
            euler_install_packages = f.read()
        return euler_install_packages.strip("\n").split('\n')

    @staticmethod
    def ks_script():
        file_path = os.path.realpath(__file__ + '../../euleros_x86_ks.cfg')
        with open(file_path, 'r') as ks_file:
            _ks_script = ks_file.read()
        return _ks_script


class ARMEuler:
    @staticmethod
    def euler_install_packages():
        file_name = "rpmlist_arm"
        file_path = os.path.realpath(__file__ + '../../' + file_name)
        with open(file_path, 'r') as f:
            euler_install_packages = f.read()
        return euler_install_packages.strip("\n").split('\n')

    @staticmethod
    def ks_script():
        file_path = os.path.realpath(__file__ + '../../euleros_arm_ks.cfg')
        with open(file_path, 'r') as ks_file:
            _ks_script = ks_file.read()
        return _ks_script
