# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback
import utils.common.log as logger
from utils.common.exception import FCDException
from utils.common.fic_base import StepBaseInterface
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.message import Message
from plugins.DistributedStorage.scripts.BusinessSeparate.implement.tc_install_driver import InstallDriver


class InstallDriverIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        storage_bmc_list = self.db.get_install_os_list_info(self.pod_id)
        osd_list = list()
        for bmc in storage_bmc_list:
            osd_node = dict()
            osd_node['om_ip'] = bmc["manageIp"]
            (root, osd_node['root_pwd'], osd_node['user'], osd_node['passwd']) = bmc["creuser"].split(',')
            osd_list.append(osd_node)
        fs_args = dict()
        fs_args['osd_list'] = osd_list
        self.fs_args = fs_args

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            InstallDriver(project_id, pod_id, self.fs_args).run()
        except FCDException as e:
            logger.error("Failed install driver, details: %s" % str(e))
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error("Failed install driver, details: %s" % str(e))
            logger.error(traceback.format_exc())
            return Message(500, FCDException(626109, str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
