# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
HP、DELL等通用服务器storcli工具安装
"""
from utils.common import log as logger
from utils.common.fic_base import TestCase
from utils.business.hardware_raid_tool_util import RAIDToolApi
from platforms.project.ProjectUtils import get_project_condition_boolean


class InstallStorcli(TestCase):
    def __init__(self, project_id, pod_id, fs_args):
        self.project_id = project_id
        self.pod_id = pod_id
        self.osd_list = fs_args.get('osd_list')

    def procedure(self):
        if not self.osd_list:
            if get_project_condition_boolean(self.project_id, 'ExpansionMgmtRes_ServiceNode'):
                # 扩纯云服务节点不需要安装
                info_msg = 'The storcli tool needs to be installed on no OSD node. Skip.'
                logger.info(info_msg)
                return
            else:
                err_msg = 'The OSD node list is empty. Check whether the parameter information is correct.'
                logger.error(err_msg)
                raise Exception(err_msg)
        node = self.osd_list[0]
        user = node.get('user')
        passwd = node.get('passwd')
        root_pwd = node.get('root_pwd')
        osd_ip_list = [osd.get('om_ip') for osd in self.osd_list]
        logger.info('The node list to install storcli tool is : %s', osd_ip_list)

        logger.info('Start to install storcli tool')
        raid_obj = RAIDToolApi(project_id=self.project_id,
                               os_ip_list=osd_ip_list,
                               os_username=user,
                               os_password=passwd,
                               root_password=root_pwd)
        raid_obj.install_raid_tool(osd_ip_list)
        logger.info('The storcli tool is successfully installed.')
