# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import time
import utils.common.log as logger
from utils.common.exception import FCUException
from plugins.DistributedStorage.common.upgrade_operate import UpgradeOperate
from plugins.DistributedStorage.common.base import TestCase


class PreUpgradeCheck(TestCase):
    def __init__(self, project_id, pod_id, fs_args, **kwargs):
        super(PreUpgradeCheck, self).__init__(project_id, pod_id)
        self.more_args = kwargs
        self.opr = UpgradeOperate(fs_args)
        self.user_name = fs_args["user_name"]
        self.password = fs_args["password"]

    def procedure(self):
        logger.info('Start upgrade task.')
        status_code, error_code, error_des = self.opr.try_login(
            self.user_name, self.password)
        if status_code != 200 or error_code != 0:
            err_msg = "Failed to login deploy manager, " \
                      "Detail:[status:%s,code:%s]%s"\
                      % (status_code, error_code, error_des)
            logger.error(err_msg)
            raise FCUException(621013, err_msg)

        logger.info('pre upgrade check.')
        self.pre_check_checker()

    def pre_check_checker(self):
        ret_result, ret_data = self.opr.pre_check()
        if ret_result["code"] != '0':
            err_msg = "pre upgrade check failed, Detail:[result:%s, data:%s]" \
                      % (ret_result, ret_data)
            logger.error(err_msg)
            raise FCUException(621013, err_msg)
        logger.info('get pre upgrade check status.')
        check_timeout = 3600
        while check_timeout > 0:
            ret_result, ret_data = self.opr.get_pre_check_status()
            if ret_result["code"] != '0':
                err_msg = "set upgrade to version mode failed, Detail:" \
                          "[result:%s, data:%s]" % (ret_result, ret_data)
                logger.error(err_msg)
                raise FCUException(621013, err_msg)
            if ret_data["status"] == "precheck_success":
                logger.info("pre check success")
                break
            elif ret_data["status"] == "precheck_failure":
                failed_component = ret_data.get("prechecking_component")
                check_progress = ret_data["progress"]
                err_msg = "[%s] pre-check failed, progress [%s]" % (
                    failed_component, str(check_progress))
                logger.error("%s, Detail:[result:%s, data:%s]" % (
                    err_msg, ret_result, ret_data))
                raise FCUException(621013, err_msg)
            elif ret_data["status"] == "precheck":
                logger.info("pre check status result: %s, data: %s"
                            % (ret_result, ret_data))
            else:
                logger.error("pre check status failed. result: %s, data: %s"
                             % (ret_result, ret_data))
            time.sleep(10)
            check_timeout -= 10
        if check_timeout <= 0:
            failed_component = ret_data.get("precheckignComponent")
            check_progress = ret_data["progress"]
            err_msg = "[%s] pre-check timeout, progress [%s]" \
                      % (failed_component, str(check_progress))
            logger.error("%s, Detail:[result:%s, data:%s]"
                         % (err_msg, ret_result, ret_data))
            raise FCUException(621013, err_msg)
