# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
Storage 上传软件包
"""
import os
import traceback
import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.basic.scripts.impl.tc_distributed_pkg import \
    DistributePkg
from plugins.DistributedStorage.common.parameter_gain import ParamsGain


class PkgDistribute(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(PkgDistribute, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id,
                                  regionid_list).get_args(suit_id)
        pkg_name, pkg_dir = ParamsGain(project_id, pod_id,
                                       regionid_list).get_storage_package()
        self.fs_args["package_name"] = pkg_name
        self.fs_args["package_path"] = os.path.join(pkg_dir, pkg_name)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start distribute package.')
        logger.info('try Start distribute package.')
        try:
            DistributePkg(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, FCUException(620006, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
