# -*- coding: utf-8 -*-
"""
HP、DELL等通用服务器storcli工具安装
"""
import traceback

from utils.common import log as logger
from utils.common.message import Message
from utils.common.fic_base import StepBaseInterface
from utils.DBAdapter.DBConnector import BaseOps
from plugins.DistributedStorage.scripts.utils.iterm.ParameterGain import ParamsGain
from plugins.DistributedStorage.scripts.ManageConverge.implement.TC_Install_Storcli import InstallStorcli


class InstallToolIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_manage_converge_args("master")

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            InstallStorcli(project_id, pod_id, self.fs_args).procedure()
            return Message(200)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, e)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        try:
            InstallStorcli(project_id, pod_id, self.fs_args).procedure()
            return Message(200)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, e)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
