# -*-coding:utf-8 -*-
import os

VERSION_DICT = {
    "euleros3.0.sp9": "29",
    "euleros3.0.sp10": "210"
}


def get_ks_script():
    ks_script_dic = {'halfOffA_euleros3.0.sp10': 'euleros_arm_30sp10_halfoff_a.sh',
                     'fullOffA_euleros3.0.sp10': 'euleros_arm_30sp10_fulloff_a.sh',
                     'halfOffA_euleros3.0.sp9': 'euleros_arm_30sp9_halfoff_a.sh',
                     'fullOffA_euleros3.0.sp9': 'euleros_arm_30sp9_fulloff_a.sh',
                     'fullOffA_euleros2.0sp8': 'euleros_arm_20sp8_fulloff_a.sh',
                     'halfOffA_euleros2.0sp8': 'euleros_arm_20sp8_halfoff_a.sh'
                     }
    for key, value in ks_script_dic.items():
        file_path = os.path.realpath(__file__ + '../../' + value)
        with open(file_path, 'r') as ks_file:
            ks_script_dic[key] = ks_file.read()
    return ks_script_dic


class ARMEuler:
    def __init__(self):
        pass

    def euler_install_packages(self, os_version):
        version = VERSION_DICT.get(os_version, "")
        file_name = "rpmlist_{}_arm".format(version) if version else "rpmlist_arm"
        file_path = os.path.realpath(__file__ + '../../' + file_name)
        with open(file_path, 'r') as f:
            euler_install_packages = f.read()
        return euler_install_packages.strip("\n").split('\n')

    ks_pre_script = get_ks_script()
