#!/bin/sh
# restart anaconda service
if [ ! -e /root/anaconda_test.log ]
then
    echo "test" > /root/anaconda_test.log
    systemctl restart anaconda.service
fi
function get_same_capacity_index() {
    local sizeArray=("${@:3}")
    sizeNum=${#sizeArray[@]}
    for((i=0;i<$sizeNum;i++))
    do
       for((j=$i+1;j<$sizeNum;j++))
       do
           if [ ${sizeArray[$i]} -eq ${sizeArray[$j]}  ];then
             eval $1=$i
             eval $2=$j
             return
           fi
       done
    done
}
function get_driver()
{
    devNum=0
    # 组软raid的卡容量大于400
    raid_size=400
    cd /sys/devices/pci0000\:00
    target=`find -name 'target*' -type d | grep ata`
    targetN=($target)
    devNum=${#targetN[@]}
    if [ $devNum -gt 4 ] || [ $devNum -lt 2 ]; then
        echo  "The number of searched soft RAID system disks is ${devNum}!"
        return
    fi
    sdArray=()
    sizeArray=()
    for tar in "${targetN[@]}"
    do
        cd /sys/devices/pci0000\:00/$tar
        block=`find -name 'block' -type d`
        cd $block
        sd=`ls`
        echo $sd
        sd_size=`lsblk | grep $sd | awk 'NR==1 {print $4}' | awk -F '.' '{print int($1)}'`
        echo $sd_size
        if [[ $sd_size -gt $raid_size ]]; then
            sdArray=(${sdArray[@]} $sd)
            sizeArray=(${sizeArray[@]} $sd_size)
        fi
    done
    eval get_same_capacity_index key1 key2 "${sizeArray[@]}"
    eval $1=${sdArray[$key1]}
    eval $2=${sdArray[$key2]}
}
function check_v6_12nvme()
{
    # 检测riser卡单板id 轮询1-3 倒数第四位
    riser_id=()
    for((i=1;i<=3;i++))
    do
        slot_id=$(printf '%#X' $i)
        borad_id=`ipmitool raw 0x30 0x93 0xDB 0x07 0x00 0x27 0x0f $slot_id 0x06 0x00 0x02 | awk '{print $5}'`
        if [ x"$borad_id" = x"" ]; then
            return 1
        fi
        if [ $borad_id = "30" ]; then
            riser_id=(${riser_id[@]} $borad_id)
        fi
        if [ ${#riser_id[@]} -eq 2 ]; then
            break
        fi
    done
    if [ ${#riser_id[@]} -ne 2 ]; then
        return 1
    fi
    # 检测硬件背板单板id 轮询1-10 倒数第四位
    back_id=()
    for((i=1;i<=10;i++))
    do
        slot_id=$(printf '%#X' $i)
        borad_id=`ipmitool raw 0x30 0x93 0xDB 0x07 0x00 0x27 0x05 $slot_id 0x06 0x00 0x02 | awk '{print $5}'`
        if [ x"$borad_id" = x"" ]; then
            return 1
        fi
        if [ $borad_id = "88" ] || [ $borad_id = "4b" ]; then
            back_id=(${back_id[@]} $borad_id)
        fi
        if [ ${#back_id[@]} -eq 2 ]; then
            return 0
        fi
    done
    return 1
}
#当前x86设备RAID卡支持3408|3004 待定
raid_card_flag=`lspci | grep -E 'SAS3508|SAS3408|SAS3004|SAS3008|Smart Storage PQI|SAS2308|SAS-3 3108|SAS3416|SAS39xx'`
#没有发现RAID卡，使用软RAID部署系统
if [ -z "${raid_card_flag}" ]; then
    check_v6_12nvme
    v6_12nv_flag=$?
    if [ $v6_12nv_flag -eq 0 ]; then
        eval get_driver fs_sd1 fs_sd2
    fi
    #匹配后面板槽位失败，默认使用前面板0号与1号槽位创建raid（IO模组2）
    if [ -z "${fs_sd1}" -o -z "${fs_sd2}" ]; then
        echo  "Can't find soft RAID system disk!"
        exit 1
    fi
fi
#Clear vg group
for vg in $(vgdisplay | grep "VG Name" | awk '{print $3}');
do
    vgremove -f /dev/${vg}*
done
#clear soft raid, try to stop 3 times
for try in {1..3}
do
    for md in $(cat /proc/mdstat | grep md | awk -F: '{print $1}')
    do
        mdadm --stop /dev/${md}
        sleep 1
    done
    md_num=$(cat /proc/mdstat | grep md | wc -l)
    if [ $md_num -eq 0 ]
    then
        echo "no md found after $try clear"
        break
    fi
done
mdadm --misc --zero-superblock /dev/${fs_sd1}1
mdadm --misc --zero-superblock /dev/${fs_sd1}2
mdadm --misc --zero-superblock /dev/${fs_sd1}3
mdadm --misc --zero-superblock /dev/${fs_sd1}4
for fs_sd in $(ls -1 /dev/${fs_sd1}*)
do
    mdadm --misc --zero-superblock /dev/${fs_sd}
done
mdadm --misc --zero-superblock /dev/${fs_sd2}1
mdadm --misc --zero-superblock /dev/${fs_sd2}2
mdadm --misc --zero-superblock /dev/${fs_sd2}3
mdadm --misc --zero-superblock /dev/${fs_sd2}4
for fs_sd in $(ls -1 /dev/${fs_sd2}*)
do
    mdadm --misc --zero-superblock /dev/${fs_sd}
done
dd if=/dev/zero of=/dev/${fs_sd1} bs=1M count=100
dd if=/dev/zero of=/dev/${fs_sd2} bs=1M count=100
mkfs.ext4 -F /dev/${fs_sd1}
mkfs.ext4 -F /dev/${fs_sd2}
#Clear data disk
for disk in $(awk '/sd[a-z]$/{print $NF}' /proc/partitions);
do
    echo "Clear disk[${disk}]"
    dd if=/dev/zero of=/dev/${disk} bs=1M count=100
done
vg_name=VolGroup2
vg_base_name=$vg_name
vgdisplay | grep -w $vg_name > /dev/null 2>&1
if [[ $? == 0 ]]
then
    i=3
    while(true)
    do
        vg_name="$vg_base_name$i"
        vgdisplay | grep -w $vg_name > /dev/null 2>&1
        if [[ $? != 0 ]]
        then
            break
        fi
        ((i=i+1))
    done
fi
modprobe nvme
modprobe libsas
modprobe host_edma_drv

echo "#Set partition disk info" > /tmp/part-include
echo "ignoredisk --only-use=${fs_sd1},${fs_sd2}" >> /tmp/part-include
echo "#Partition clearing information" >> /tmp/part-include
echo "clearpart --all --initlabel --drives=${fs_sd1},${fs_sd2}" >> /tmp/part-include
echo "zerombr" >> /tmp/part-include
echo "#-- raid part for /boot --" >> /tmp/part-include
echo "part raid.sd1_0 --fstype=\"mdmember\" --size=409 --ondrive=${fs_sd1}" >> /tmp/part-include
echo "part raid.sd2_0 --fstype=\"mdmember\" --size=409 --ondrive=${fs_sd2}" >> /tmp/part-include
echo "#-- part for /boot/efi --" >> /tmp/part-include
echo "part raid.sd1_1 --fstype=\"mdmember\" --size=307 --ondrive=${fs_sd1}" >> /tmp/part-include
echo "part raid.sd2_1 --fstype=\"mdmember\" --size=307 --ondrive=${fs_sd2}" >> /tmp/part-include
echo "#-- raid part for / --" >> /tmp/part-include
echo "part raid.sd1_2 --fstype=\"mdmember\" --size=20480 --ondrive=${fs_sd1}" >> /tmp/part-include
echo "part raid.sd2_2 --fstype=\"mdmember\" --size=20480 --ondrive=${fs_sd2}" >> /tmp/part-include
echo "#-- raid part for PV.1099 --" >> /tmp/part-include
echo "part raid.sd1_3 --fstype=\"mdmember\" --size=1 --grow --ondrive=${fs_sd1}" >> /tmp/part-include
echo "part raid.sd2_3 --fstype=\"mdmember\" --size=1 --grow --ondrive=${fs_sd2}" >> /tmp/part-include

echo "#Raid device creation" >> /tmp/part-include
echo "raid /boot --device=md0 --fstype=ext4 --level=RAID1 raid.sd1_0 raid.sd2_0" >> /tmp/part-include
echo "raid /boot/efi --device=md1 --fstype=efi --level=RAID1 --fsoptions=\"umask=0077,shortname=winnt\" raid.sd1_1 raid.sd2_1" >> /tmp/part-include
echo "raid / --device=md2 --fstype=ext4 --level=RAID1 raid.sd1_2 raid.sd2_2" >> /tmp/part-include
echo "raid pv.1 --device=md3 --fstype=ext4 --level=RAID1 raid.sd1_3 raid.sd2_3" >> /tmp/part-include
echo "#Volume group and logical volume creation" >> /tmp/part-include
echo "volgroup $vg_name --pesize=4096 pv.1" >> /tmp/part-include
echo "logvol swap --fstype swap --vgname ${vg_name} --size=5120 --name=swap" >> /tmp/part-include
echo "logvol /opt --fstype ext4 --vgname ${vg_name} --size=102400 --name=opt" >> /tmp/part-include
echo "logvol /opt/zk_disk --fstype ext4 --vgname ${vg_name} --size=66560 --name=opt.zk_disk" >> /tmp/part-include
echo "logvol /opt/ccdb_disk --fstype ext4 --vgname ${vg_name} --size=15360 --name=opt.ccdb_disk" >> /tmp/part-include
echo "logvol /opt/ccdb_disk2 --fstype ext4 --vgname ${vg_name} --size=10240 --name=opt.ccdb_disk2" >> /tmp/part-include
echo "logvol /var --fstype ext4 --vgname ${vg_name} --size=5120 --name=var" >> /tmp/part-include
echo "logvol /var/crash --fstype ext4 --vgname ${vg_name} --size=30720 --name=var.crash" >> /tmp/part-include
echo "logvol /var/log --fstype ext4 --vgname ${vg_name} --size=81920 --name=var.log" >> /tmp/part-include
echo "logvol /var/log/audit --fstype ext4 --vgname ${vg_name} --size=1024 --name=var.log.audit" >> /tmp/part-include
echo "logvol /tmp --fstype ext4 --vgname ${vg_name} --size=40960 --name=tmp --fsoptions=\"nodev\"" >> /tmp/part-include
echo "logvol /usr --fstype ext4 --vgname ${vg_name} --size=20480 --name=usr" >> /tmp/part-include
echo "logvol /home --fstype ext4 --vgname ${vg_name} --size=10240 --name=home" >> /tmp/part-include
echo "#System bootloader configuration" >> /tmp/part-include
echo "#Set the RAID device md0 as the first drive in the BIOS boot order." >> /tmp/part-include