# -*-coding:utf-8 -*-
import os

VERSION_DICT = {
    "euleros3.0.sp9": "29",
    "euleros3.0.sp10": "210"
}


def get_ks_script():
    ks_script_dic = {'halfOffA_euleros3.0.sp10': 'euleros_x86_30sp10_halfoff_a.sh',
                     'fullOffA_euleros3.0.sp10': 'euleros_x86_30sp10_fulloff_a.sh',
                     'euleros3.0.sp9': 'euleros_x86_30sp9.sh',
                     'euleros2.0sp5': 'euleros_x86_20sp5.sh',
                     'euleros2.0sp3': 'euleros_x86_20sp3.sh',
                     }
    for key, value in ks_script_dic.items():
        file_path = os.path.realpath(__file__ + '../../' + value)
        with open(file_path, 'r') as ks_file:
            ks_script_dic[key] = ks_file.read()
    return ks_script_dic


class PublicItems:
    def __init__(self):
        pass
    noarch_post_script = 'sed -i "s/chage -d 0/chage -d `date +%Y-%m-%d`/g" /etc/EulerOS_init.sh; ' \
                         'sed -i "s/chage -d 0/chage -d `date +%Y-%m-%d`/g" ' \
                         '/opt/reinforce_os/reinforce_script/014.Add_and_Modify_User.sh; ' \
                         'if [ -f /etc/EulerOS_init.sh ];then sh /etc/EulerOS_init.sh; ' \
                         'else sh /opt/reinforce_os/reinforce_os.sh install; fi; chage -d `date +%Y-%m-%d` root'


class X86Euler:
    def __init__(self):
        pass

    def euler_install_packages(self, os_version):
        version = VERSION_DICT.get(os_version, "")
        file_name = "rpmlist_{}_x86".format(version) if version else "rpmlist_x86"
        file_path = os.path.realpath(__file__ + '../../' + file_name)
        with open(file_path, 'r') as f:
            euler_install_packages = f.read()
        return euler_install_packages.strip("\n").split('\n')

    ks_pre_script = get_ks_script()
