# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorage.scripts.implement.TC_Create_VM import CreateVM
from plugins.DistributedStorage.scripts.utils.iterm.ParameterGain import ParamsGain
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.message import Message
from platforms.project.ProjectUtils import get_project_condition_boolean


class CreateVMIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        params = ParamsGain(project_id, pod_id, self.db)
        if get_project_condition_boolean(self.project_id, 'TenantStorFB80&ExpansionServiceStorage'):
            self.fs_args = params.get_business_separate_expand_fusionstorage_args()
        else:
            self.fs_args = params.get_business_separate_args()
        self.fs_args["uvp_install_path"] = params.get_pkg_path('uvp')
        self.vm_create = CreateVM(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Manager，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.vm_create.run()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.vm_create.delete_created_vm_from_cps()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return CreateVM(project_id, pod_id, self.fs_args).run()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
