#!/usr/bin/env python
# -*- coding: utf-8 -*-
from plugins.DistributedStorageReplication.scripts.common_utils.ping_utils import PingSSHclient, client_can_pinged_to
from utils.business.param_util import ParamUtil
from utils.business.vm_util import can_vm_pinged_to
from utils.common.exception import FCDException
from utils.common.fic_base import StepBaseInterface, TestCase
from utils.common.message import Message
import utils.common.log as logger
from platforms.project.ProjectUtils import get_project_condition_boolean
from plugins.DistributedStorage.scripts.logic.InstallOperate import InstallOperate
from utils.common.ssh_util import Ssh as ssh


class ConfigRoute(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：安装rpm依赖包，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        return ConfigRoute_01(project_id, pod_id).run()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return ConfigRoute_01(project_id, pod_id).run()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()


class ConfigRoute_01(TestCase):
    def __init__(self, project_id, pod_id):
        super(ConfigRoute_01, self).__init__(project_id, pod_id)
        self.service_name = "FusionStorageBlockReplication"
        self.param_util = ParamUtil()
        self.install_operate = InstallOperate(self.project_id, self.pod_id)

    def pre_condition(self):
        pass

    def procedure(self):

        log_module_name = self.args_dict['log_module_name']
        logger.init(log_module_name)
        self.pod_id = self.args_dict['pod_id']
        self.project_id = self.args_dict['project_id']
        try:
            # 连通性校验
            self.fsa_info = self.db.get_install_os_list_info(self.pod_id, 'rep')
            fsa_ip_list = [info['manageIp'] for info in self.fsa_info]
            flag, result = self.check_connect_boolean(fsa_ip_list)
            if not flag:
                logger.error('Some node can not connect.detail:%s' % str(result))
                raise FCDException(627175, str(result))
            logger.info('nodes connect check success.')
            logger.info('Start to get net info, netmask, gw.')
            net_info_list = self.get_net_info()
            logger.info('End to get net info,detail:%s' % str(net_info_list))
            pre_check_fail_list = []
            fail_list = []
            for info in self.fsa_info:
                creuser = info['creuser'].split(',')
                client = self.install_operate.create_ssh_root_client(info['manageIp'], creuser[2],
                                                                     creuser[3], creuser[1])
                # 给与文件可执行权限
                cmd0 = "chmod +x /etc/rc.local;echo last cmd result: $?\n"
                result = ssh.ssh_exec_command_return(client, cmd0)
                logger.info("chmod result: %s" % str(result))
                ips = info['replication_plane_ip'].split(',')
                # 获取路由级别
                level1, level2 = self.check_level(client)
                logger.info('End to  get route level,detail:%s,%s' % (level1, level2))
                if get_project_condition_boolean(self.project_id, 'CSHAStorage_TFB'):
                    # 配置仲裁网络策略路由即时生效和持久化
                    self.config_arbitration_network_policy_route(level2, info, client, fail_list)
                # 执行命令，配置策略路由即时生效
                self.config_policy_based_route(level1, level2, ips, net_info_list, client, info, fail_list)
                # 将策略路由写入文件时间持久化
                self.config_policy_based_route_persistence(ips, net_info_list, client, info, fail_list)
                if client:
                    ssh.ssh_close(client)
            fail_list = list(set(fail_list))
            if fail_list or pre_check_fail_list:
                logger.error('Config fail.fail bmc info list: %s, pre check fail list:%s' % (
                    str(fail_list), str(pre_check_fail_list)))
                raise FCDException(627176, str(fail_list), str(pre_check_fail_list))
            self.connect_check()
            return Message(200)
        except FCDException as e:
            logger.error(e)
            return Message(500, e)
        except Exception as e:
            logger.error(e)
            return Message(500, FCDException(627177, str(e)))

    def config_arbitration_network_policy_route(self, level2, info, client, fail_list):
        # 配置仲裁网络策略路由即时生效和持久化
        logger.info('Start to get arb net info .')
        arb_net = self.get_net_info(flag=False)
        logger.info('End to get arb net info.detail:%s' % str(arb_net))
        cmd3 = "arb_nic_res=$(ifconfig |grep \"arb\"); " \
               "if [ -z \"${arb_nic_res}\" ] && { ifup arb 2>/dev/null 1>&2; }; " \
               "then ifconfig | grep -q arb || echo \"ERROR: arb is not up\"; " \
               "route_arb=$(cat /etc/iproute2/rt_tables |grep 'arb'); " \
               "if [ -z \"${route_arb}\" ] && { echo \"%s arb\" >> /etc/iproute2/rt_tables;}; " \
               "then ip route flush table arb; ip rule add from %s table arb; " \
               "ip route add %s dev arb src %s table arb; " \
               "ip route add default dev arb via %s table arb; fi; fi" % \
               (str(level2 + 1), info['arbitration_plane_ip'], arb_net[1], info['arbitration_plane_ip'],
                arb_net[0])
        cmd3 += ";echo last_status=$?"
        logger.info('Start to exe command.detail:%s' % cmd3)
        result = ssh.ssh_exec_command_return(client, cmd3)
        logger.info("Config arbitration network policy route result: %s" % result)
        if str(result).find('last_status=0') < 0:
            check_cmd3 = "ip route list table arb | grep \"default via %s dev arb\" >/dev/null;" \
                         % arb_net[0]
            logger.info('Start to exe check command.detail:%s' % check_cmd3)
            check_cmd3 += ";echo last_status=$?"
            result = ssh.ssh_exec_command_return(client, check_cmd3)
            if str(result).find('last_status=0') < 0:
                msg = 'bmcip:%s,manageip:%s' % (info['bmc_ip'], info['manageIp'])
                fail_list.append(msg)
        cmd4 = "arb_res=$(cat /etc/rc.local |grep \"arb\"); " \
               "if [ -z \"${arb_res}\" ]; " \
               "then echo \"service network restart\" >> /etc/rc.local; " \
               "echo \"ip route flush table arb\" >> /etc/rc.local; " \
               "echo \"ip rule add from %s table arb\" >> /etc/rc.local; " \
               "echo \"ip route add %s dev arb src %s table arb\" >> /etc/rc.local; " \
               "echo \"ip route add default dev arb via %s table arb\" >> /etc/rc.local; fi" % \
               (info['arbitration_plane_ip'], arb_net[1], info['arbitration_plane_ip'], arb_net[0])
        cmd4 += ";echo last_status=$?"
        logger.info('Start to exe command.detail:%s' % cmd4)
        result = ssh.ssh_exec_command_return(client, cmd4)
        logger.info("Config arbitration network policy route persistence result: %s" % result)
        if str(result).find('last_status=0') < 0:
            msg = 'bmcip:%s,manageip:%s' % (info['bmc_ip'], info['manageIp'])
            fail_list.append(msg)

    def config_policy_based_route(self, level1, level2, ips, net_info_list, client, info, fail_list):
        cmd1 = "rep_nic_res=$(ifconfig |grep rep); " \
               "if [ -z \"${rep_nic_res}\" ] && { ifconfig rep0 up; ifconfig rep1 up;}; " \
               "then route_rep=$(cat /etc/iproute2/rt_tables |grep rep); fi; " \
               "if [ -z \"${route_rep}\" ] && { echo \"%s rep_eth0\" >> /etc/iproute2/rt_tables; " \
               "echo \"%s rep_eth1\" >> /etc/iproute2/rt_tables; }; " \
               "then ip route flush table rep_eth0; " \
               "ip route flush table rep_eth1; " \
               "ip rule add from %s table rep_eth0; " \
               "ip rule add from %s table rep_eth1; " \
               "ip route add %s dev rep0 src %s table rep_eth0; " \
               "ip route add %s dev rep1 src %s table rep_eth1; " \
               "ip route add default dev rep0 via %s table rep_eth0; " \
               "ip route add default dev rep1 via %s table rep_eth1; fi" % \
               (str(level1), str(level2), ips[0], ips[1], net_info_list[1],
                ips[0], net_info_list[3], ips[1], net_info_list[0], net_info_list[2])
        cmd1 += ";echo last_status=$?"
        logger.info('Start to exe command.detail:%s' % cmd1)
        result = ssh.ssh_exec_command_return(client, cmd1, 180, 3)
        logger.info("config policy-based route result: %s" % result)
        if str(result).find('last_status=0') < 0:
            check_cmd1 = "ip route list table rep_eth1 | grep \"default via %s dev rep1\"" % net_info_list[2]
            logger.info('Start to exe check command.detail:%s' % check_cmd1)
            check_cmd1 += ";echo last_status=$?"
            result = ssh.ssh_exec_command_return(client, check_cmd1)
            logger.info("check route result: %s " % result)
            if str(result).find('last_status=0') < 0:
                msg = 'bmcip:%s,manageip:%s' % (info['bmc_ip'], info['manageIp'])
                fail_list.append(msg)

    def config_policy_based_route_persistence(self, ips, net_info_list, client, info, fail_list):
        cmd2 = "rep_res=$(cat /etc/rc.local |grep \"rep\"); " \
               "if [ -z \"${rep_res}\" ]; " \
               "then echo \"ip route flush table rep_eth0\" >> /etc/rc.local; " \
               "echo \"ip route flush table rep_eth1\" >> /etc/rc.local;" \
               "echo \"ip rule add from %s table rep_eth0\" >> /etc/rc.local; " \
               "echo \"ip rule add from %s table rep_eth1\" >> /etc/rc.local; " \
               "echo \"ip route add %s dev rep0 src %s table rep_eth0\" >> /etc/rc.local; " \
               "echo \"ip route add %s dev rep1 src %s table rep_eth1\" >> /etc/rc.local; " \
               "echo \"ip route add default dev rep0 via %s table rep_eth0\" >> /etc/rc.local; " \
               "echo \"ip route add default dev rep1 via %s table rep_eth1\" >> /etc/rc.local; fi" % \
               (ips[0], ips[1], net_info_list[1], ips[0], net_info_list[3], ips[1], net_info_list[0],
                net_info_list[2])
        cmd2 += ";echo last_status=$?"
        logger.info('Start to exe command.detail:%s' % cmd2)
        result = ssh.ssh_exec_command_return(client, cmd2)
        logger.info("config policy-based route persistence result: %s" % result)
        if str(result).find('last_status=0') < 0:
            logger.error("failed to config route info into /etc/rc.local")
            msg = 'bmcip:%s,manageip:%s' % (info['bmc_ip'], info['manageIp'])
            fail_list.append(msg)

    def connect_check(self):
        fail_list = []
        rep_gw1 = self.param_util.get_param_value(self.pod_id, self.service_name, 'fusionstorage_rep_gateway1')
        rep_gw2 = self.param_util.get_param_value(self.pod_id, self.service_name, 'fusionstorage_rep_gateway2')
        arb_gw = self.param_util.get_param_value(self.pod_id, self.service_name, 'fusionstorage_arb_gateway')
        for node in self.fsa_info:
            creuser = node['creuser'].split(',')
            client = PingSSHclient(host=node['manageIp'], username=creuser[2], pwd=creuser[3], root_pwd=creuser[1])
            client.switch_root(creuser[1])
            if not client_can_pinged_to(client, rep_gw1) or not client_can_pinged_to(client, rep_gw2):
                msg = "bmcip:%s,replication plane check fail" % node['bmc_ip']
                fail_list.append(msg)
            if get_project_condition_boolean(self.project_id, 'CSHAStorage_TFB'):
                if not client_can_pinged_to(client, arb_gw):
                    msg = "bmcip:%s,arbitration plane check fail" % node['bmc_ip']
                    fail_list.append(msg)
            client.close()
        if fail_list:
            logger.error('connect check fail,detail:%s' % str(fail_list))
            raise FCDException(627178, str(fail_list))
        return True

    def check_level(self, client):
        for num in range(200, 255):
            cmd = "cat /etc/iproute2/rt_tables |grep %s" % num
            cmd = cmd + ";echo last cmd result: $?\n"
            result = ssh.execute_command(client, cmd, 180, 3)
            if str(result).find('last cmd result: 0') < 0:
                return num, num + 1
        raise Exception()

    def get_net_info(self, flag=True):
        """
复制平面1网络掩码：fusionstorage_rep_netmask1
复制平面1网关：fusionstorage_rep_gateway1

复制平面2网络掩码：fusionstorage_rep_netmask2
复制平面2网关：fusionstorage_rep_gateway2

仲裁网络掩码：fusionstorage_arb_netmask
仲裁网络网关：fusionstorage_arb_gateway
        :return:
        """
        if flag:
            key_list = ['fusionstorage_rep_gateway1', 'fusionstorage_rep_netmask1',
                        'fusionstorage_rep_gateway2', 'fusionstorage_rep_netmask2']
        else:
            key_list = ['fusionstorage_arb_gateway', 'fusionstorage_arb_netmask']
        tmp_list = []
        for key in key_list:
            value = self.param_util.get_param_value(self.pod_id, self.service_name, key)
            if key.find("netmask") >= 0:
                value = exchange_mask(value)
                tmp_list.append(value)

            if key.find('gateway') >= 0:
                tmp_list.append(value)
                net = value.split('.')
                net[-1] = '0'
                net_str = '.'.join(net)
                tmp_list.append(net_str)
        if flag:
            value_list = [tmp_list[0], str(tmp_list[1]) + '/' + str(tmp_list[2]),
                          tmp_list[3], str(tmp_list[4]) + '/' + str(tmp_list[5])]
        else:
            value_list = [tmp_list[0], str(tmp_list[1]) + '/' + str(tmp_list[2])]
        return value_list

    def check_connect_boolean(self, ip_list):
        fail_list = []
        for ip in ip_list:
            if not can_vm_pinged_to(ip):
                fail_list.append(ip)
        if fail_list:
            return False, fail_list
        return True, ''

    def post_condition(self):
        pass

    def failure(self):
        pass


def count_bit(bin_str):
    return len([i for i in bin_str if i == '1'])


def exchange_mask(mask):
    """返回子网掩码的位数，255.255.255.0  返回 24"""
    mask_splited = mask.split('.')
    mask_count = [count_bit(bin(int(i))) for i in mask_splited]
    return sum(mask_count)
