/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dm;

import com.huawei.dm.BuildHardCode;
import com.huawei.dm.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Http11ProtocolWithKeystore
extends Http11NioProtocol {
    private static Logger log = LogManager.getLogger(Http11ProtocolWithKeystore.class);
    private static final String AES = "AES";
    private static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    private static final int IV_BYTE_NUMBER = 16;
    private static final int KEY_BYTE_NUMBER = 16;
    private static String key = null;
    private static byte[] iv = null;
    private static String classpath = System.getProperty("user.dir");
    private static String prefixPath = classpath + File.separator + File.separator;
    private static final String IV_PATH = prefixPath + "iv.cfg";
    private static final String KEY_PATH = prefixPath + "CrtHardCode";
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();

    private static void parseIVFile() {
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(IV_PATH);
            byte[] byArray = new byte[16];
            if (fileInputStream != null && (n = ((InputStream)fileInputStream).available()) > 0 && ((InputStream)fileInputStream).read(byArray) > 0) {
                iv = byArray;
            }
        }
        catch (IOException iOException) {
            log.error("IV File IO Exception.");
        }
        catch (Exception exception) {
            log.error("iv file is not exist.");
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    log.error("close io input stream error!");
                }
            }
        }
    }

    private static byte[] getIvFromFile() {
        if (iv == null) {
            Http11ProtocolWithKeystore.parseIVFile();
        }
        return iv;
    }

    private static byte[] getKey() throws IOException, URISyntaxException, GeneralSecurityException {
        Optional<X509Certificate> optional = Util.getInstance().readCertBuf(BuildHardCode.getCertificationBytes(KEY_PATH));
        byte[] byArray = optional.get().getPublicKey().getEncoded();
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, 16);
        return byArray2;
    }

    private static byte[] getIV() {
        return Http11ProtocolWithKeystore.getIvFromFile();
    }

    private static byte[] generateRandom() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    private static void writeRandomIV(byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(IV_PATH);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            log.error("Write Random Error.");
        }
        catch (Exception exception) {
            log.error("iv file is not exist.");
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    log.error("Write Random Error.");
                }
            }
        }
    }

    public void init() {
        String string = this.getKeystorePass();
        String string2 = Http11ProtocolWithKeystore.decipher(string, null);
        this.setKeystorePass(string2);
        try {
            super.init();
        }
        catch (Exception exception) {
            log.error("Init error!");
        }
    }

    public static String encript(String string) {
        if (null == string) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
            SecretKeySpec secretKeySpec = new SecretKeySpec(Http11ProtocolWithKeystore.getKey(), AES);
            byte[] byArray = Http11ProtocolWithKeystore.generateRandom();
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray));
            byte[] byArray2 = cipher.doFinal(string.getBytes(DEFAULT_CHARSET));
            Http11ProtocolWithKeystore.writeRandomIV(byArray);
            return new String(Base64.encodeBase64((byte[])byArray2), "8859_1");
        }
        catch (Exception exception) {
            log.error("Encript error.");
            return null;
        }
    }

    public static String decipher(String string, byte[] byArray) {
        if (string == null) {
            log.error("Decipher error.");
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
            SecretKeySpec secretKeySpec = new SecretKeySpec(Http11ProtocolWithKeystore.getKey(), AES);
            if (byArray == null) {
                byArray = Http11ProtocolWithKeystore.getIV();
            }
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray));
            byte[] byArray2 = null;
            try {
                byArray2 = string.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.error("Decipher UnsupportedEncodingException error.");
                return null;
            }
            byte[] byArray3 = cipher.doFinal(Base64.decodeBase64((byte[])byArray2));
            return new String(byArray3, DEFAULT_CHARSET);
        }
        catch (Exception exception) {
            log.error("Decipher error.");
            return null;
        }
    }
}

