/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());
    private static final Util INSTANCE = new Util();

    private Util() {
    }

    public static Util getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<X509Certificate> readCertBuf(byte[] byArray) throws GeneralSecurityException, IOException {
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(byteArrayInputStream);
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    Optional<X509Certificate> optional = Optional.of(x509Certificate);
                    return optional;
                }
                Optional<X509Certificate> optional = Optional.empty();
                return optional;
            }
            finally {
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Close byte array failed.");
                }
            }
        }
        throw new IOException("Certificate data is empty.");
    }
}

