#!/bin/bash
CURRENT_DIR=$(cd "$(dirname "$0")"; pwd)
source "${CURRENT_DIR}/common.sh"

initLog

readonly COMPONENT="fsm"

readonly DSWARE_USER_GROUP="omm"                     #DSWARE用户组
readonly DSWARE_USER="dsware"                        #DSWARE用户名
readonly DSWARE_UID=2011                             #DSWARE用户ID

readonly FSADMIN_USER_GROUP="omm"                    #fsadmin用户组
readonly FSADMIN_USER="fsadmin"                      #fsadmin用户名
readonly FSADMIN_UID=5000                            #fsadmin用户ID

readonly OAMU_GROUPID_OMM=2000

function check_dsware_user()
{
    grep "^${DSWARE_USER}:" /etc/passwd >>/dev/null 2>&1
    if [ $? -ne 0 ]; then  
        id ${DSWARE_UID}  >>/dev/null 2>&1
        if [ $? -eq 0 ]; then
            log "${DSWARE_UID} user id has been used already!"
            logger ${COMPONENT}/33759503/${DSWARE_UID}/${OAMU_GROUPID_OMM}
            return 1
        fi        
    fi
    
    grep "^${DSWARE_USER_GROUP}:" /etc/group >>/dev/null 2>&1
    if [ $? -ne 0 ]; then  
        grep ":${OAMU_GROUPID_OMM}:" /etc/group >>/dev/null 2>&1
        if [ $? -eq 0 ]; then
            log "${OAMU_GROUPID_OMM} group id has been used already!"
            logger ${COMPONENT}/33759503/${DSWARE_UID}/${OAMU_GROUPID_OMM}
            return 1
        fi
    fi
    
    return 0
}

function check_fsadmin_user()
{
    grep "^${FSADMIN_USER}:" /etc/passwd >>/dev/null 2>&1
    if [ $? -ne 0 ]; then  
        id ${FSADMIN_UID}  >>/dev/null 2>&1
        if [ $? -eq 0 ]; then
            log "${FSADMIN_UID} user id has been used already!"
            logger ${COMPONENT}/33759503/${FSADMIN_UID}/${OAMU_GROUPID_OMM}
            return 1
        fi        
    fi
        
    return 0
}

main()
{
    check_dsware_user
    if [ $? -ne 0 ];then
        return 1
    fi
    
    check_fsadmin_user
    if [ $? -ne 0 ]; then
        return 1
    fi
        
    return 0
}

##################################main process##################################
main
if [ $? -eq 0 ]; then
    exit 0
else
    exit 1
fi

