#! /usr/bin/python
# -*- coding: UTF-8 -*-
import re
import sys


NUM8 = 8
NUM0 = 0
#######################################################
# parameter:ip ip address
# desc:Do deCompress ipv6 address
# return: ip address
#######################################################
def deCompressIpv6(ip):
    ipArr = ip.split("::")
    if len(ipArr) > 1:
        count = len(ipArr[0].split(":")) + len(ipArr[1].split(":"))
        zeroCount = NUM8 - count
        fullIp = ipArr[0]
        if fullIp == "":
            fullIp = "0"
        for i in range(0, zeroCount):
            fullIp += ":0"
        fullIp += ":"
        fullIp += ipArr[1]
        if ipArr[1] == "":
            fullIp += "0"
        return fullIp.lower()
    else:
        return ip.lower()


#######################################################
# parameter:ip ip address
# desc:Do compress ipv6 address
# return: ip address  001:022:0000:0003:0:0:0:004
#######################################################
def compressIpv6(ip):
    fullIp = fullDeCompressIpv6(ip)
    #compress as linux model
    compressIp = re.sub(r'^0{1,3}(.*)', r'\1', fullIp.lower())
    compressIp = re.sub(r'((?:(?:^|:)0+\b){2,}):?(?!\S*\b\1:0+\b)(\S*)', r'::\2', compressIp)
    compressIp = re.sub(r':0{1,3}([0-9a-fA-F]+)',r":\1", compressIp)

    return compressIp

#######################################################
# parameter:ip ip address
# desc:Do expact ipv6 address
# return: ip address
#######################################################
def fullDeCompressIpv6(ip):
    fullIp = deCompressIpv6(ip)
    ipArr = fullIp.split(":")
    for i in range(NUM0, NUM8):
        ipArr[i] = '{:0>4}'.format(ipArr[i])
    return ":".join(ipArr)


#######################################################
# parameter:ip ip address未判断合法IP地址
# desc:Do compress ipv6 address
# return: ip address
# usage: restoreAndCompressIpv6.py de_compress/compress 0:0:0:0:0:0:0:0
#######################################################
if __name__ == "__main__":
    argument_number = len(sys.argv)
    if argument_number < 2:
        print 'Usage:restoreAndCompressIpv6.py de_compress/compress 0:0:0:0:0:0:0:0'
        exit(1)
    operate_type = sys.argv[1]
    ip_address = sys.argv[2]

    ret = None
    if operate_type == "de_compress":
        ret = deCompressIpv6(ip_address)
    elif operate_type == "compress":
        ret = compressIpv6(ip_address)
    else:
        print ip_address
        exit(1)

    print ret
