#!/bin/bash
CURRENT_DIR=$(cd "$(dirname "$0")"; pwd)
source "${CURRENT_DIR}/common.sh"

initLog

readonly COMPONENT="oam-u"
readonly OAMU_USER_OMM="omm"
readonly OAMU_GROUP_OMM="omm"
readonly OAMU_USER_OMMDBA="ommdba"
readonly OAMU_USER_OAM="oam"
readonly OAMU_GROUP_OAM="oam"
readonly OAMU_GROUP_DFVGROUP="dfvgroup"

readonly OAMU_USERID_OMM=5010
readonly OAMU_GROUPID_OMM=2000
readonly OAMU_USERID_OMMDBA=2002
readonly OAMU_USERID_OAM=5001
readonly OAMU_GROUPID_OAM=5001
readonly OAMU_GROUPID_DFVGROUP=1001

function check_omm_user()
{
    grep "^${OAMU_USER_OMM}:" /etc/passwd >>/dev/null 2>&1
    if [ $? -ne 0 ]; then  
        id ${OAMU_USERID_OMM}  >>/dev/null 2>&1
        if [ $? -eq 0 ]; then
            log "${OAMU_USERID_OMM} user id has been used already!"
            logger ${COMPONENT}/33759503/${OAMU_USERID_OMM}/${OAMU_GROUPID_OMM}
            return 1
        fi        
    fi
    
    grep "^${OAMU_GROUP_OMM}:" /etc/group >>/dev/null 2>&1
    if [ $? -ne 0 ]; then  
        grep ":${OAMU_GROUPID_OMM}:" /etc/group >>/dev/null 2>&1
        if [ $? -eq 0 ]; then
            log "${OAMU_GROUPID_OMM} group id has been used already!"
            logger ${COMPONENT}/33759503/${OAMU_USERID_OMM}/${OAMU_GROUPID_OMM}
            return 1
        fi
    fi
    
    return 0
}

function check_ommdba_user()
{
    grep "^${OAMU_USER_OMMDBA}:" /etc/passwd >>/dev/null 2>&1
    if [ $? -ne 0 ]; then  
        id ${OAMU_USERID_OMMDBA}  >>/dev/null 2>&1
        if [ $? -eq 0 ]; then
            log "${OAMU_USERID_OMMDBA} user id has been used already!"
            logger ${COMPONENT}/33759503/${OAMU_USERID_OMMDBA}/${OAMU_GROUPID_OMM}
            return 1
        fi        
    fi
        
    return 0
}

main()
{
    check_omm_user
    if [ $? -ne 0 ];then
        return 1
    fi
    
    check_ommdba_user
    if [ $? -ne 0 ]; then
        return 1
    fi
        
    return 0
}

##################################main process##################################
main
if [ $? -eq 0 ]; then
    exit 0
else
    exit 1
fi

