#!/bin/bash

if [ `echo "$0" |grep -c "/"` -gt 0 ]; then
    cd ${0%/*}
fi
. ./config.inc

typeset path=$(grep "path=" config.inc | awk -F= '{print $2}')
typeset support_noroot=$(grep "open_no_root=" config.inc | awk -F= '{print $2}')
typeset logfile=/var/log/restagent/cur_log/logfile
user_name=restagentusr
user_group=restagentgroup

if [ ! -d /var/log/restagent ];then
    mkdir /var/log/restagent
fi
if [ ! -d /var/log/restagent/cur_log ];then
    mkdir /var/log/restagent/cur_log
fi
if [ ! -d /var/log/restagent/his_log ];then
    mkdir /var/log/restagent/his_log
fi

function errorecho
{
    echo "`date +"%Y-%m-%d %X"` [ERROR] "$1"isn't existed, "$2" failed, please check the file and retry...." >> ${logfile}
    echo "`date +"%Y-%m-%d %X"` [ERROR] "$1" isn't existed, "$2" failed, please check the file and retry...."
}
#备份
function backup
{
    echo "`date +"%Y-%m-%d %X"` backup start...." >> ${logfile}
    echo "`date +"%Y-%m-%d %X"` backup start...." 
   
    pathacl=${path}"/apache-tomcat/webapps/RestAgent/WEB-INF/classes/config/acl.json"
    pathconfig=${path}"/apache-tomcat/webapps/RestAgent/WEB-INF/classes/config.properties"
    pathserver=${path}"/apache-tomcat/conf/server.xml"
    pathkeystore=${path}"/apache-tomcat/conf/.keystore"
    kmc_primary_dat=${path}"/apache-tomcat/kmc/kmca_primary_file.dat"
    kmc_standby_dat=${path}"/apache-tomcat/kmc/kmca_standby_file.dat"

    if [ ! -f $pathacl ];then
        errorecho $pathacl "backup"
        return 1
    fi
    if [ ! -f $pathconfig ];then
        errorecho $pathconfig "backup"
        return 1
    fi
    if [ ! -f $pathserver ];then
        errorecho $pathserver "backup"
        return 1
    fi
    if [ ! -f $pathkeystore ];then
        errorecho $pathkeystore "backup"
        return 1
    fi
    
    if [ -d ${path}/ConfigFileBackup ];then
      #删除文件
      rm -rf ${path}/ConfigFileBackup  
    fi
    mkdir -p ${path}/ConfigFileBackup
    
    cp -p $pathacl ${path}/ConfigFileBackup/
    cp -p $pathconfig ${path}/ConfigFileBackup/
    cp -p $pathserver ${path}/ConfigFileBackup/
    cp -p $pathkeystore ${path}/ConfigFileBackup/
    
    if [ -f $kmc_primary_dat ];then
        cp -p $kmc_primary_dat ${path}/ConfigFileBackup/
    fi
    
    if [ -f $kmc_standby_dat ];then
        cp -p $kmc_standby_dat ${path}/ConfigFileBackup/
    fi
   
    echo "`date +"%Y-%m-%d %X"` backup end...." >> ${logfile} 
    echo "`date +"%Y-%m-%d %X"` backup end...."     
    return 0
}

#恢复
function restore
{
    echo "`date +"%Y-%m-%d %X"` restore start...." >> ${logfile}
    echo "`date +"%Y-%m-%d %X"` restore start...."
    if [ ! -d ${path}/ConfigFileBackup ];then
       echo "`date +"%Y-%m-%d %X"` the files try to restore are not existed."
       echo "`date +"%Y-%m-%d %X"` the files try to restore are not existed." >> ${logfile}
    else
        if [ ! -f ${path}/ConfigFileBackup/acl.json ];then
            errorecho ${path}/ConfigFileBackup/acl.json "restore"
            return 1
        fi
        if [ ! -f ${path}/ConfigFileBackup/config.properties ];then
            errorecho ${path}/ConfigFileBackup/config.properties "restore"
            return 1
        fi
        if [ ! -f ${path}/ConfigFileBackup/server.xml ];then
            errorecho ${path}/ConfigFileBackup/server.xml "restore"
            return 1
        fi
        if [ ! -f ${path}/ConfigFileBackup/.keystore ];then
            errorecho ${path}/ConfigFileBackup/.keystore "restore"
            return 1
        fi
        cp -p ${path}/ConfigFileBackup/acl.json ${path}/apache-tomcat/webapps/RestAgent/WEB-INF/classes/config/
        cp -p ${path}/ConfigFileBackup/config.properties ${path}/apache-tomcat/webapps/RestAgent/WEB-INF/classes/
        cp -p ${path}/ConfigFileBackup/server.xml ${path}/apache-tomcat/conf/
        cp -p ${path}/ConfigFileBackup/.keystore ${path}/apache-tomcat/conf/
        if [ -f ${path}/ConfigFileBackup/kmca_primary_file.dat ];then
            cp -p ${path}/ConfigFileBackup/kmca_primary_file.dat ${path}/apache-tomcat/kmc/
        fi
        
        if [ -f ${path}/ConfigFileBackup/kmca_standby_file.dat ];then
            cp -p ${path}/ConfigFileBackup/kmca_standby_file.dat ${path}/apache-tomcat/kmc/
        fi
        
    fi
    echo "`date +"%Y-%m-%d %X"` restore end...." >> ${logfile} 
    echo "`date +"%Y-%m-%d %X"` restore end...." 
    return 0
}

function createuser()
{
    groupadd ${user_group}  2>/dev/null

    if id ${user_name} 2>/dev/null; then
        echo "user ${user_name} is exist "  >> ${logfile}
    else
        useradd -m -g ${user_group}  ${user_name} -s /sbin/nologin
    fi
}

function setPremission()
{
    chmod 750 ${path} -R 
    chmod 550 ${path}/apache-tomcat/lib -R
    chmod 550 ${path}/apache-tomcat/bin -R

    chmod 600 ${path}/apache-tomcat/conf/ -R
    chmod 700 ${path}/apache-tomcat/conf 
    chmod 600 ${path}/apache-tomcat/kmc -R
    chmod 700 ${path}/apache-tomcat/kmc
    chmod 500 ${path}/apache-tomcat/kmclib -R

    chmod 750 /var/log/restagent
    chmod 750 /var/log/restagent/cur_log
    chmod 640 /var/log/restagent/cur_log/logfile
    chmod 750 /var/log/restagent/his_log

    mkdir -p /home/jsonbak/
    chmod 750 /home/jsonbak/ -R

    chown -h ${user_name}:${user_group} ${path} -R
    chown -h ${user_name}:${user_group} /var/log/restagent -R
    chown -h ${user_name}:${user_group} /home/jsonbak/ -R

    chmod 550 ${path}/jre -R
    chown -h ${user_name}:${user_group} ${path}/jre -R
}

function selfStart()
{
   echo "`date +"%Y-%m-%d %X"` config self start...." >> ${logfile}  
   cp -rf nasrestagent /etc/init.d/nasrestagent 
   cp -rf watchdog_nasrestagent.sh /etc/init.d/watchdog_nasrestagent.sh 
   cp -rf auto_nasrestagent /etc/init.d/auto_nasrestagent
   
   chmod +x /etc/init.d/nasrestagent
   chmod +x /etc/init.d/watchdog_nasrestagent.sh 
   chmod +x /etc/init.d/auto_nasrestagent 
    
   chkconfig --add auto_nasrestagent >/dev/null
   chkconfig --level 2345 auto_nasrestagent on

   #添加sudoers文件
   cp -rf sudo_restagent /etc/sudoers.d/sudo_restagent
   chmod +r /etc/sudoers.d/sudo_restagent
   echo "`date +"%Y-%m-%d %X"` config self end...." >> ${logfile}  
}

#安装
function install
{
    echo "`date +"%Y-%m-%d %X"` Install start...."
    echo "`date +"%Y-%m-%d %X"` Install start...." >> ${logfile}  
    # 安装时创建非root用户和组
    createuser
    
    # 配置自启动
    selfStart
   
   if [ -f ${path}/apache-tomcat.zip ];then
      if [ -d ${path}/apache-tomcat ];then
         if [ -d ${path}/backup_tomcat/apache-tomcat ];then
            rm -rf ${path}/backup_tomcat/apache-tomcat
         fi
         if [ ! -d ${path}/backup_tomcat ];then
            mkdir ${path}/backup_tomcat
         fi
         cp -r ${path}/apache-tomcat ${path}/backup_tomcat/apache-tomcat
         rm -rf ${path}/apache-tomcat
      fi
      
      unzip -o ${path}/apache-tomcat.zip -d ${path}  >/dev/null
      cd ${path}/apache-tomcat/bin
      chmod +x *
   fi
   
   if [ -f ${path}/jre.tar.gz ];then
        if [  -d ${path}/jre ];then
            rm -rf ${path}/jre
        fi
        mkdir -p ${path}/jre
        tar -xvf ${path}/jre.tar.gz --strip-components 1 -C ${path}/jre  >/dev/null
   fi
   #修改支持root的标记
    sed -i "s/open_no_root=.*/open_no_root=${support_noroot}/g" ${path}/apache-tomcat/webapps/RestAgent/WEB-INF/classes/config.properties &> /dev/null
    setPremission
    echo "`date +"%Y-%m-%d %X"` Install end...." 
    echo "`date +"%Y-%m-%d %X"` Install end...." >> ${logfile}
}

#卸载
function uninstall
{
   echo "`date +"%Y-%m-%d %X"` Uninstall start...." 
   echo "`date +"%Y-%m-%d %X"` Uninstall start...." >> ${logfile}
   ./nasrestagent stop
   #备份文件
   #backup
   chkconfig --del auto_nasrestagent >/dev/null 2>&1
   rm /etc/init.d/nasrestagent
   rm /etc/init.d/watchdog_nasrestagent.sh
   rm /etc/init.d/auto_nasrestagent
   rm -rf /etc/sudoers.d/sudo_restagent
   #删除安装文件
   if [ -d ${path}/apache-tomcat ];then
        if [ -d ${path}/backup_tomcat/apache-tomcat ];then
            rm -rf ${path}/backup_tomcat/apache-tomcat
        fi
    
       rm -rf ${path}/apache-tomcat
   fi
   
   if [  -d ${path}/jre ];then
       rm -rf ${path}/jre
   fi
   echo "`date +"%Y-%m-%d %X"` Uninstall is success!"
   echo "`date +"%Y-%m-%d %X"` Uninstall end...." >> ${logfile}
}

function update
{
    createuser
    echo "`date +"%Y-%m-%d %X"` update start...." >> ${logfile}
    echo "`date +"%Y-%m-%d %X"` update start...." 

    selfStart

    if [ -f ${path}/apache-tomcat.zip ];then
        ./nasrestagent stop
        if [ -f ${path}/jre.tar.gz ];then
            if [ -d ${path}/jre ];then
                rm -rf ${path}/jre
            fi
            mkdir -p ${path}/jre
            tar -xvf ${path}/jre.tar.gz --strip-components 1 -C ${path}/jre    >/dev/null
        fi
        backup
        if [ $? -eq 1 ];then
            return
        fi
        #删除apache-tomcat下所有文件
        if [ -d ${path}/apache-tomcat ];then
          rm -rf ${path}/apache-tomcat
        fi

        unzip -o ${path}/apache-tomcat.zip -d ${path} >/dev/null
        chmod +x ${path}/apache-tomcat/bin/*
        restore
        if [ $? -eq 1 ];then
            return
        fi
        sed -i "s/open_no_root=.*/open_no_root=${support_noroot}/g" ${path}/apache-tomcat/webapps/RestAgent/WEB-INF/classes/config.properties &> /dev/null
        setPremission
        ./nasrestagent start
        echo "`date +"%Y-%m-%d %X"` update success...." >> ${logfile}
        echo "`date +"%Y-%m-%d %X"` update success...." 
    else
        echo "`date +"%Y-%m-%d %X"` update failed, apache-tomcat.zip is not exist...." >> ${logfile}
        echo "`date +"%Y-%m-%d %X"` update failed, apache-tomcat.zip is not exist...."
    fi
    echo "`date +"%Y-%m-%d %X"` update end...." >> ${logfile}
    echo "`date +"%Y-%m-%d %X"` update end...." 
}


case "$1" in
    install)
        install
        exit
        ;;
        
    uninstall)
        uninstall
        exit
        ;;   
        
    update)
        update
        exit
        ;;    

    backup)
        backup
        exit
        ;;

    restore)
        restore
        exit
        ;;
    *)
       echo "`date +"%Y-%m-%d %X"` parameter $1 is error! actions: install|uninstall|update|backup|restore "    
       ;; 
esac
