#!/bin/bash

CUR_DIR=$(dirname $(readlink -f $0))
source ${CUR_DIR}/bin/commonUtil.sh
UPGRADE_BACKUP_PATH="/home/rest/backUpProcessFile"
INSTALL_PATH=/opt/dfv/oam/rest

LOG_NAME="rollback.log"
RESTCONVERT_SCRIPT_LOG_PATH="/var/log/restconvert/scriptLog"
UNINSTALL_SCRIPT_PATH="/opt/dfv/oam/rest/RestConvert/uninstall.sh"

BACKUP_INSTALL_SCRIPT_PATH="${UPGRADE_BACKUP_PATH}/rest/RestConvert/install.sh"

LOG_FILE="${RESTCONVERT_SCRIPT_LOG_PATH}/${LOG_NAME}"

initLog "${RESTCONVERT_SCRIPT_LOG_PATH}" "${LOG_NAME}"

chown -Rh ${OAM_SYS_USER}:${OAM_SYS_GROUP} ${LOG_FILE}

CURRENT_VERSION="/opt/dfv/oam/rest/RestConvert/rest-version"

BACKUP_VERSION="/home/rest/backUpProcessFile/rest/RestConvert/rest-version"

function checkBeforeRollback()
{
  if [ ! -d ${UPGRADE_BACKUP_PATH}/rest ];then
    log_warn "not exist upgrade back up file,can not rollback"
    return 1
  fi
  checkVersionNum
  if [ $? -ne 0 ];then
    log_warn "check version number failed";
    return 1
  fi
  log_info "check before rollback success"
  return 0
}

function checkVersionNum()
{
  if [ ! -f ${CURRENT_VERSION} ];then
    log_warn "current version file not exist,skip check"
    return 0
  fi

  local backupMajorVersion=`grep 'version=' ${BACKUP_VERSION} | awk -F '=' '{print $2}' | awk -F '-' '{print $1}'`
  if [ "X${backupMajorVersion}" != "X8.1.3" ];then
    log_error "backup major version ${backupMajorVersion} is incorrect"
    return 1
  fi

  local oldMajorVersion=`grep 'version=' ${CURRENT_VERSION} | awk -F '=' '{print $2}' | awk -F '-' '{print $1}'`
  if [ "X${oldMajorVersion}" != "X8.1.3" ];then
    log_error "current major version ${oldMajorVersion} is incorrect"
    return 1
  fi

  local backupMinorVersion=`grep 'version=' ${BACKUP_VERSION} | awk -F '=' '{print $2}' | awk -F '-' '{print $2}'`
  if [ "X${backupMinorVersion}" = "X" ];then
    log_error "can not get backup minor version"
    return 1
  fi

  local oldMinorVersion=`grep 'version=' ${CURRENT_VERSION} | awk -F '=' '{print $2}' | awk -F '-' '{print $2}'`
  if [ "X${oldMinorVersion}" = "X" ];then
    log_error "can not get current minor version"
    return 1
  fi

  let newMinorNum=${backupMinorVersion}
  let oldMinorNum=${oldMinorVersion}
  if [ $newMinorNum -gt $oldMinorNum ];then
    log_error "backup version num can not be larger than current,backup is ${backupMinorVersion},current is ${oldMinorVersion}"
    return 1
  fi
  log_info "check version success,backup version is ${backupMajorVersion}-${backupMinorVersion}"
  return 0
}

function installOldRest()
{
  sh ${BACKUP_INSTALL_SCRIPT_PATH} >> /dev/null 2>&1
  return $?
}

function uninstallCurrentRest()
{
  # 如果回滚时 进程安装路径存在卸载脚本 优先使用
  if [ -f ${UNINSTALL_SCRIPT_PATH} ];then
    log_info "exec ${UNINSTALL_SCRIPT_PATH}"
    sh ${UNINSTALL_SCRIPT_PATH} 1 >> /dev/null 2>&1
    return $?
  fi
  log_info "exec ${CUR_DIR}/uninstall.sh"
  sh ${CUR_DIR}/uninstall.sh 1 >> /dev/null 2>&1
  return $?
}

function main()
{
  checkBeforeRollback
  if [ $? -ne 0 ];then
    log_warn "check before rollback failed"
    return 1
  fi

  echo "start unInstall current RestConvert..."
  uninstallCurrentRest
  if [ $? -ne 0 ];then
    log_warn "uninstallCurrentRest failed"
    return 1
  fi

  echo "start install old RestConvert..."
  installOldRest
  if [ $? -ne 0 ];then
    log_warn "installOldRest failed"
    return 1
  fi

  return 0
}

main
ret=$?
[[ ${ret} -eq 0 ]] && print_info "restConvert rollback successfully!" || print_error "restConvert rollback failed!"
exit ${ret}