/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans;

import com.sun.beans.WeakCache;
import com.sun.beans.WildcardTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.GenericArrayTypeImpl;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public final class TypeResolver {
    private static final WeakCache<Type, Map<Type, Type>> CACHE = new WeakCache();

    public static Type resolveInClass(Class<?> clazz, Type type) {
        return TypeResolver.resolve(TypeResolver.getActualType(clazz), type);
    }

    public static Type[] resolveInClass(Class<?> clazz, Type[] typeArray) {
        return TypeResolver.resolve(TypeResolver.getActualType(clazz), typeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type resolve(Type type, Type type2) {
        if (type2 instanceof Class) {
            return type2;
        }
        if (type2 instanceof GenericArrayType) {
            Type type3 = ((GenericArrayType)type2).getGenericComponentType();
            return (type3 = TypeResolver.resolve(type, type3)) instanceof Class ? Array.newInstance((Class)type3, 0).getClass() : GenericArrayTypeImpl.make(type3);
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Type[] typeArray = TypeResolver.resolve(type, parameterizedType.getActualTypeArguments());
            return ParameterizedTypeImpl.make((Class)parameterizedType.getRawType(), typeArray, parameterizedType.getOwnerType());
        }
        if (type2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type2;
            Type[] typeArray = TypeResolver.resolve(type, wildcardType.getUpperBounds());
            Type[] typeArray2 = TypeResolver.resolve(type, wildcardType.getLowerBounds());
            return new WildcardTypeImpl(typeArray, typeArray2);
        }
        if (type2 instanceof TypeVariable) {
            Map<Type, Type> map;
            Object object = CACHE;
            synchronized (object) {
                map = CACHE.get(type);
                if (map == null) {
                    map = new HashMap<Type, Type>();
                    TypeResolver.prepare(map, type);
                    CACHE.put(type, map);
                }
            }
            object = map.get(type2);
            if (object == null || object.equals(type2)) {
                return type2;
            }
            object = TypeResolver.fixGenericArray((Type)object);
            return TypeResolver.resolve(type, (Type)object);
        }
        throw new IllegalArgumentException("Bad Type kind: " + type2.getClass());
    }

    public static Type[] resolve(Type type, Type[] typeArray) {
        int n = typeArray.length;
        Type[] typeArray2 = new Type[n];
        for (int i = 0; i < n; ++i) {
            typeArray2[i] = TypeResolver.resolve(type, typeArray[i]);
        }
        return typeArray2;
    }

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type[] typeArray = typeVariable.getBounds();
            return 0 < typeArray.length ? TypeResolver.erase(typeArray[0]) : Object.class;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getUpperBounds();
            return 0 < typeArray.length ? TypeResolver.erase(typeArray[0]) : Object.class;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Array.newInstance(TypeResolver.erase(genericArrayType.getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Unknown Type kind: " + type.getClass());
    }

    public static Class[] erase(Type[] typeArray) {
        int n = typeArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = TypeResolver.erase(typeArray[i]);
        }
        return classArray;
    }

    private static void prepare(Map<Type, Type> map, Type type) {
        TypeVariable<Class<T>>[] typeVariableArray;
        Class clazz = (Class)(type instanceof Class ? type : ((ParameterizedType)type).getRawType());
        TypeVariable<Class<T>>[] typeVariableArray2 = clazz.getTypeParameters();
        Type[] typeArray = typeVariableArray = type instanceof Class ? typeVariableArray2 : ((ParameterizedType)type).getActualTypeArguments();
        assert (typeVariableArray2.length == typeVariableArray.length);
        for (int i = 0; i < typeVariableArray2.length; ++i) {
            map.put(typeVariableArray2[i], typeVariableArray[i]);
        }
        Type type2 = clazz.getGenericSuperclass();
        if (type2 != null) {
            TypeResolver.prepare(map, type2);
        }
        for (Type type3 : clazz.getGenericInterfaces()) {
            TypeResolver.prepare(map, type3);
        }
        if (type instanceof Class && typeVariableArray2.length > 0) {
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(TypeResolver.erase((Type)entry.getValue()));
            }
        }
    }

    private static Type fixGenericArray(Type type) {
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            if ((type2 = TypeResolver.fixGenericArray(type2)) instanceof Class) {
                return Array.newInstance((Class)type2, 0).getClass();
            }
        }
        return type;
    }

    private static Type getActualType(Class<?> clazz) {
        Type[] typeArray = clazz.getTypeParameters();
        return typeArray.length == 0 ? clazz : ParameterizedTypeImpl.make(clazz, typeArray, clazz.getEnclosingClass());
    }
}

