#!/bin/bash
#日志函数
precheck_log_file="/var/log/precheck.log"
readonly PRECHECK_PKG="/opt/fusionstorage/precheck"
readonly SCRIPT_PKG="/opt/fusionstorage/precheck/precheck"
CURRENT_DIR=$(cd "$(dirname "$0")"; pwd)
source ${CURRENT_DIR}/common.sh
initLog
pkg=`ls ${PRECHECK_PKG} | grep precheck | grep zip | awk -F '.zip' '{print $1}'`
if [ $? -ne 0 -o -z "$pkg" ]; then
    log "ERROR" "precheck zip file not exist failed" > ${precheck_log_file}
	exit 1
fi
cd ${PRECHECK_PKG}
unzip $pkg.zip
if [ $? -ne 0 ]; then
    log "ERROR" "precheck file unzip failed" > ${precheck_log_file}
	exit 1
fi
if [ ! -d /opt/fusionstorage/precheck/precheck ];then
    log "ERROR" "precheck dir not exist failed" > ${precheck_log_file}
    exit 1
fi
chmod 700 -R ${SCRIPT_PKG}
cd ${SCRIPT_PKG}
rm -rf precheck.sh
for i in `find ./ -type f|egrep -E "\.sh$"`
do
    sh $i > /dev/null 2>&1
    if [ $? -ne 0 ];then
        log "ERROR" "precheck $i failed" > ${precheck_log_file}
        exit 1
    fi
done
log "success" "file unzip success" > ${precheck_log_file}
exit 0