#!/bin/bash

CUR_DIR=$(dirname $(readlink -f $0))
source ${CUR_DIR}/commonUtil.sh

scriptName=$(basename $0)

LOG_NAME="logMonitor.log"
RESTCONVERT_SCRIPT_LOG_PATH="/var/log/restconvert/scriptLog"
RESTCONVERT_RUN_LOG_PATH="/var/log/restconvert/run"
LOG_FILE="${RESTCONVERT_SCRIPT_LOG_PATH}/${LOG_NAME}"

#暂定脚本日志最多占10M
SCRIPT_LOG_MAX_SIZE=10240

initLog "${RESTCONVERT_SCRIPT_LOG_PATH}" "${LOG_NAME}"

chown -h ${OAM_SYS_USER}:${OAM_SYS_GROUP} ${LOG_FILE}

function main()
{
  checkScriptLogSize
  setReadOnlyForHistoryRunLog
}


function getScriptLogSize()
{
  totalSize=0
  logList=`find ${RESTCONVERT_SCRIPT_LOG_PATH} -name "*.log"`
  for log in ${logList}
  do
  fileSize=$(du -s ${log} | cut -f1)
  ((totalSize=${fileSize}+${totalSize}))
  done
  echo $totalSize
}

#依次清理最大的日志
function checkScriptLogSize()
{
  local currentSize=$(getScriptLogSize)
  while ((currentSize > ${SCRIPT_LOG_MAX_SIZE}))
  do
  maxLogFile=$(find ${RESTCONVERT_SCRIPT_LOG_PATH} -name "*.log" | xargs du -s | sort -nr | head -1 | cut -f2)
  if [ -f ${maxLogFile} ];then
    echo "" > ${maxLogFile}
    log_info "clean ${maxLogFile} success"
  else
    log_warn "not exist log"
    return 0
  fi
  currentSize=$(getScriptLogSize)
  done
}

#将归档的run日志改为只读400
function setReadOnlyForHistoryRunLog()
{
  if [ ! -d ${RESTCONVERT_RUN_LOG_PATH} ];then
    return 0
  fi
  find ${RESTCONVERT_RUN_LOG_PATH} -name "*.log" -user rest  -perm -600 | grep -v "rest.log" | grep -v "kmc.log" | xargs chmod 400
  find ${RESTCONVERT_RUN_LOG_PATH} -name "*.zip" -user rest  -perm -600 | grep -v "rest.log" | grep -v "kmc.log" | xargs chmod 400
}

main
exit $?




