#!/bin/bash

CUR_DIR=$(dirname $(readlink -f $0))
source ${CUR_DIR}/commonUtil.sh

LOG_NAME="start.log"
RESTCONVERT_SCRIPT_LOG_PATH="/var/log/restconvert/scriptLog"
LOG_FILE="${RESTCONVERT_SCRIPT_LOG_PATH}/${LOG_NAME}"

RUN_LOG_PATH="/var/log/restconvert/run/"
RUN_LOG_NAME="/var/log/restconvert/run/rest.log"

INSTALL_PATH=/opt/dfv/oam/rest
export LD_LIBRARY_PATH=/opt/dfv/oam/rest/RestConvert/kmclib/:$LD_LIBRARY_PATH
initLog "${RESTCONVERT_SCRIPT_LOG_PATH}" "${LOG_NAME}"

appPropertyPath=${INSTALL_PATH}/RestConvert/resources/application.properties
LOG_CONFIG_FILE=${INSTALL_PATH}/RestConvert/resources/logback.xml

scriptName=$(basename $0)

function main()
{
  log_info "start restConvert task"
  ip addr show | fgrep -w ${SERVICE_FLOAT_IP} > /dev/null 2>&1
  if [ $? -ne 0 ]; then
      log_warn "float ip is not in local eth,can not start"
      return 1
  fi
  isRestCovertRunning
  if [ $? -eq 0 ];then
      print_error "restConvert is already running,no need to start again"
      return 0
  fi
  refreshServerIp
  if [ $? -ne 0 ]; then
      print_error "set float ip failed"
      return 1
  fi
  creatRunningLog
  if [ $? -ne 0 ]; then
      print_error "create running log failed"
      return 1
  fi
  startRestProcess
  if [ $? -ne 0 ]; then
      print_error "start rest process failed"
      return 1
  fi
  return 0
}

#创建进程的运行日志
function creatRunningLog()
{
  mkdir -p "${RUN_LOG_PATH}"
  if [ ! -f ${RUN_LOG_NAME} ];then
    log_info "create run log"
    touch ${RUN_LOG_NAME}
    chown -Rh ${OAM_SYS_USER}:${OAM_SYS_GROUP}  ${RUN_LOG_PATH}
    chmod 750 ${RUN_LOG_PATH}
    chmod 640 ${RUN_LOG_NAME}
  fi
  return 0
}

#修改进程监听的浮动IP
function refreshServerIp()
{
  is_link ${appPropertyPath}
  if [ $? -ne 0 ]; then
      scriptExelog "app property path is link,failed. [Line:${LINENO}]" ${FUNCNAME} ${scriptName}
      return 1
  fi
  sed -i "s/server\.address=.*/server\.address=${SERVICE_FLOAT_IP}/g" ${appPropertyPath}
  if [ $? -ne 0 ]; then
      scriptExelog "set server ip ${SERVICE_FLOAT_IP} failed [Line:${LINENO}]" ${FUNCNAME} ${scriptName}
      return 1
  fi
  return 0
}

function startRestProcess()
{
  log_info "start restConvert process"
  local user=$(whoami)
  if [[ "${user}"x != "rest"x ]];then
      su - rest -s "/bin/bash" -c "nohup ${INSTALL_PATH}/RestConvert/jre/bin/java -Dspring.config.location=${appPropertyPath} -Xmx256m -Xms256m -XX:MaxDirectMemorySize=128m -XX:MetaspaceSize=128m -XX:MaxMetaspaceSize=128m -jar ${INSTALL_PATH}/RestConvert/RestConvert.jar --logging.config=${LOG_CONFIG_FILE} >> ${LOG_FILE} 2>&1 &"
  else
      nohup ${INSTALL_PATH}/RestConvert/jre/bin/java -Dspring.config.location=${appPropertyPath} -Xmx256m -Xms256m -XX:MaxDirectMemorySize=128m -XX:MetaspaceSize=128m -XX:MaxMetaspaceSize=128m -jar ${INSTALL_PATH}/RestConvert/RestConvert.jar --logging.config=${LOG_CONFIG_FILE} >> ${LOG_FILE} 2>&1 &
  fi
  if [ $? -ne 0 ]; then
      scriptExelog "start restConvert process failed [Line:${LINENO}]" ${FUNCNAME} ${scriptName}
      return 1
  fi
  log_info "start restConvert process success"
  return 0
}

main
ret=$?
[[ ${ret} -eq 0 ]] && print_info "start restConvert successfully!" || print_error "restConvert start failed!"
exit ${ret}