#!/bin/bash

CUR_DIR=$(dirname $(readlink -f $0))
source ${CUR_DIR}/bin/commonUtil.sh
UPGRADE_BACKUP_PATH="/home/rest/backUpProcessFile"
INSTALL_PATH=/opt/dfv/oam/rest

LOG_NAME="rollback.log"
RESTCONVERT_SCRIPT_LOG_PATH="/var/log/restconvert/scriptLog"
UNINSTALL_SCRIPT_PATH="/opt/dfv/oam/rest/RestConvert/uninstall.sh"

BACKUP_INSTALL_SCRIPT_PATH="${UPGRADE_BACKUP_PATH}/rest/RestConvert/install.sh"

LOG_FILE="${RESTCONVERT_SCRIPT_LOG_PATH}/${LOG_NAME}"

initLog "${RESTCONVERT_SCRIPT_LOG_PATH}" "${LOG_NAME}"

chown -Rh ${OAM_SYS_USER}:${OAM_SYS_GROUP} ${LOG_FILE}

CURRENT_VERSION="/opt/dfv/oam/rest/RestConvert/rest-version"

BACKUP_VERSION="/home/rest/backUpProcessFile/rest/RestConvert/rest-version"

function checkBeforeRollback()
{
  if [ ! -d ${UPGRADE_BACKUP_PATH}/rest ];then
    log_warn "not exist upgrade back up file,can not rollback"
    return 1
  fi
  checkVersionNum
  if [ $? -ne 0 ];then
    log_warn "check version number failed";
    return 1
  fi
  log_info "check before rollback success"
  return 0
}

function checkVersionNum()
{
  local newMinorVersion=$(grep 'version=' ${CUR_DIR}/rest-version | awk -F '=' '{print $2}')
  local oldMinorVersion=$(grep 'version=' ${CURRENT_VERSION_FILE} | awk -F '=' '{print $2}')
  if [ "${newMinorVersion}" -eq "${oldMinorVersion}" ];then
    log_error "version num must not be same,new is ${newMinorVersion},current is ${oldMinorVersion}"
    return 1
  fi
  log_info "check version success,new version is ${newMinorVersion}"
  return 0
}

function installOldRest()
{
  sh ${BACKUP_INSTALL_SCRIPT_PATH} >> /dev/null 2>&1
  return $?
}

function uninstallCurrentRest()
{
  # 如果回滚时 进程安装路径存在卸载脚本 优先使用
  if [ -f ${UNINSTALL_SCRIPT_PATH} ];then
    log_info "exec ${UNINSTALL_SCRIPT_PATH}"
    sh ${UNINSTALL_SCRIPT_PATH} 1 >> /dev/null 2>&1
    return $?
  fi
  log_info "exec ${CUR_DIR}/uninstall.sh"
  sh ${CUR_DIR}/uninstall.sh 1 >> /dev/null 2>&1
  return $?
}

function main()
{
  checkBeforeRollback
  if [ $? -ne 0 ];then
    log_warn "check before rollback failed"
    return 1
  fi

  echo "start unInstall current RestConvert..."
  uninstallCurrentRest
  if [ $? -ne 0 ];then
    log_warn "uninstallCurrentRest failed"
    return 1
  fi

  echo "start install old RestConvert..."
  installOldRest
  if [ $? -ne 0 ];then
    log_warn "installOldRest failed"
    return 1
  fi

  return 0
}

main
ret=$?
[[ ${ret} -eq 0 ]] && print_info "restConvert rollback successfully!" || print_error "restConvert rollback failed!"
exit ${ret}