# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback
import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import HCCIException
from utils.DBAdapter.DBConnector import BaseOps
from plugins.ResourceCheck.common.libs import network_libs
from plugins.DistributedStorage.Deploy.scripts.PreCheck.implement.job_network_connectivity_check \
    import CheckNetworkConnectivity
from plugins.DistributedStorage.utils.common.deploy_constant import DeployConstant


class CheckServiceNetInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(CheckServiceNetInterface, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        fs_args = dict()
        fs_args["port_name"] = DeployConstant.MGR_STORAGE_NET_INTF
        fs_args["net_info"] = network_libs.get_net_info_from_lld(self.pod_id,
                                                                 'fusionstorage_service', 'DistributedStorageBusiness')
        fs_args["net_plane"] = 'storage_plane'
        fs_args["nic_bond_mode"] = self.db.get_user_input_cloud_param_by_key(
            self.project_id, 'fusionstorage_service_plane_mode')
        fs_args["vlan_flag"] = False
        self.implement = CheckNetworkConnectivity(project_id, pod_id, fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        try:
            self.implement.procedure()
        except HCCIException as e1:
            logger.error(traceback.format_exc())
            logger.error(str(e1))
            return Message(500, e1)
        except Exception as e2:
            logger.error(traceback.format_exc())
            logger.error(e2)
            return Message(500, HCCIException('365113', e2))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
