# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback

import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.business.resource_check.do_disable_jbod import DoDisableJBODLibs
from plugins.DistributedStorage.Deploy.scripts.PreCheck.common.device_operate import PreCheckPublicOperate


class StorageNodeDisableJbodInf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(StorageNodeDisableJbodInf, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.pre_check_opr = PreCheckPublicOperate(self.project_id, self.pod_id)
        self.osd_nodes_info = create_disable_jbod_body(self.pre_check_opr.get_bmc_info(need_rep=True))

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装&配置
        :return: Message对象
        """
        logger.info("start to disabled JBOD")
        try:
            DoDisableJBODLibs(project_id, self.osd_nodes_info).disable_jbod()
        except Exception as err:
            logger.error(traceback.format_exc())
            return Message(500, err)
        logger.info("JBOD disabled successfully")
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :return: Message对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        插件内部接口：执行注册，该接口由execute接口调用，
        工具框架不会直接调用此接口
        :return:
        """
        return Message()


def create_disable_jbod_body(nodes_info):
    for node in nodes_info:
        if not node["deploy_component"]:
            node["bmc_role"] = "osd"
            continue
        node["bmc_role"] = node["deploy_component"]
    return nodes_info

