# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import traceback

import utils.common.log as logger
from utils.common.message import Message
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorage.Replication.scripts.implement.fs_issue_hypermetro_certificate\
    import IssueHyperMetroCert


class IssueHyperMetroCertInf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id

    def execute(self, project_id, pod_id):
        try:
            IssueHyperMetroCert(project_id, pod_id).procedure()
        except HCCIException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        return Message(200)

    def rollback(self, project_id, pod_id):
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        return Message()

    def pre_check(self, project_id, pod_id):
        return Message()
