/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw.geom;

import java.awt.geom.Path2D;
import java.util.Objects;
import org.apache.poi.sl.draw.geom.AdjustPoint;
import org.apache.poi.sl.draw.geom.Context;
import org.apache.poi.sl.draw.geom.PathCommand;

public final class QuadToCommand
implements PathCommand {
    private final AdjustPoint pt1 = new AdjustPoint();
    private final AdjustPoint pt2 = new AdjustPoint();

    public void setPt1(AdjustPoint pt1) {
        if (pt1 != null) {
            this.pt1.setX(pt1.getX());
            this.pt1.setY(pt1.getY());
        }
    }

    public void setPt2(AdjustPoint pt2) {
        if (pt2 != null) {
            this.pt2.setX(pt2.getX());
            this.pt2.setY(pt2.getY());
        }
    }

    @Override
    public void execute(Path2D.Double path, Context ctx) {
        double x1 = ctx.getValue(this.pt1.getX());
        double y1 = ctx.getValue(this.pt1.getY());
        double x2 = ctx.getValue(this.pt2.getX());
        double y2 = ctx.getValue(this.pt2.getY());
        path.quadTo(x1, y1, x2, y2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuadToCommand)) {
            return false;
        }
        QuadToCommand that = (QuadToCommand)o;
        return Objects.equals(this.pt1, that.pt1) && Objects.equals(this.pt2, that.pt2);
    }

    public int hashCode() {
        return Objects.hash(this.pt1, this.pt2);
    }
}

