#!/usr/bin/env python
# -*-coding:utf-8-*-
import os
import sys
import six
import argparse

from dsware_kmc_tool import KmcApi
import logging.handlers

LOG_DIR = "/var/log/fsc_cli"
LOG_PATH = "/var/log/fsc_cli/fsc_cli.log"
CUR_DIR = os.path.dirname(os.path.abspath(__file__))
PARENT_DIR = os.path.abspath(CUR_DIR + os.path.sep + "..")
DSWARE_API_LOG_DIR = PARENT_DIR + os.path.sep + "log"
DSWARE_API_LOG_PATH = DSWARE_API_LOG_DIR + os.path.sep + "dsware_api.log"


def should_log_file():
    return not os.path.islink(LOG_PATH)


logger = logging.getLogger('')
try:
    if os.path.exists(DSWARE_API_LOG_DIR):
        LOG_DIR = DSWARE_API_LOG_DIR
        LOG_PATH = DSWARE_API_LOG_PATH
    if not os.path.exists(LOG_DIR):
        os.makedirs(LOG_DIR)
        os.chmod(LOG_DIR, 750)
    handler = logging.handlers.RotatingFileHandler(LOG_PATH, maxBytes=1024 * 1024, backupCount=1)
    formatter = logging.Formatter(
        fmt="[%(asctime)s] [%(levelname)s] [%(process)d] [%(filename)s:%("
            "lineno)d]: %(message)s",
        datefmt="%Y-%m-%d %H:%M:%S")
    handler.setFormatter(formatter)
    loggingFilter = logging.Filter()
    loggingFilter.filter = should_log_file
    handler.addFilter(loggingFilter)
    logger.addHandler(handler)
except Exception as e:
    logger.error("init log error %s" % e)


def main(libpath, domain_id, encrypt_text):
    logger.info("enter main")

    kmc_tool_path = os.path.join(libpath, "libfsbKmcTool.so")
    kmcApi = KmcApi(kmc_tool_path)
    retOk = kmcApi.initial()
    if not retOk:
        logger.error("init kmc library fail")
        sys.exit(1)

    logger.info("init kmc library success")
    retOk, textOut = kmcApi.decrypt(domain_id, encrypt_text)
    if not retOk:
        logger.error("kmc decrypt fail")
        sys.exit(1)
    if isinstance(textOut, bytes):
        textOut = textOut.decode()
    logger.info("success decrypt")
    print(textOut)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='KMC decrypt tool')
    parser.add_argument("-i", "--domain-id", type=int, dest="domain_id", required=True)
    parser.add_argument("-l", "--kmc-library-path", dest="kmc_library_path", required=True)
    args = parser.parse_args()
    if six.PY2:
        encrypt_text = raw_input("")
    else:
        encrypt_text = input("")

    main(args.kmc_library_path, args.domain_id, encrypt_text)
