# -*- coding: utf-8 -*-
import os

from utils.business.project_condition_utils import get_project_condition_boolean
from utils.common.fic_base import TestCase
import utils.common.log as logger
from plugins.DistributedStorage.logic.InstallOperate import InstallOperate
from utils.client.FSPAuthClient import FSPAuthClient
from utils.Driver.CloudDC.OpenStack.get_host_info import GetHostInfo
from plugins.ManageOne.scripts.utils.get_solution import get_solution
from utils.business.OpenStack.cps_pkg_uploader import CpsPkgUploader


class InstallRole(TestCase):
    def __init__(self, project_id, pod_id, fs_args, condition=None, metadata=None, **kwargs):
        super(InstallRole, self).__init__(project_id, pod_id)
        self.operate = InstallOperate(self.project_id, self.pod_id, fs_args)
        self.cps_web_client = FSPAuthClient.get_cps_web_client(self.db, self.project_id, self.pod_id)
        self.cps_host_client = GetHostInfo(self.cps_web_client)
        self.condition = condition
        self.metadata = metadata
        self.more_args = kwargs
        self.progress_deploy = get_solution()
        self.pkg_file_path = fs_args.get("uvp_install_path")
        self.vbs_list = fs_args.get('vbs_list')
        self.iscsi_condition = get_project_condition_boolean(self.project_id, 'TenantStorFB_iSCSI')

    def procedure(self):
        logger.info("Install fusionstorage-block role on compute node")
        vbs_bmc_ip_list = [vbs.get('bmc_ip') for vbs in self.vbs_list]
        compute_id_list, compute_ip_list = self.cps_host_client.get_host_info(vbs_bmc_ip_list)
        if not compute_id_list:
            err_msg = "The node list is empty. There is no node to install role"
            logger.error(err_msg)
            if self.iscsi_condition:
                return
            raise Exception(err_msg)
        cps_client = FSPAuthClient.get_cps_rest_client(self.db, self.project_id, self.pod_id)
        if self.operate.check_fusionstorage_block_before_install_role(cps_client, compute_id_list):
            # 已经安装过的节点，重启角色，兼容IPSAN等场景提前部署角色，然后跳过后续安装
            self.operate.restart_fusionstorage_block_template(cps_client, compute_id_list)
            return
        if self.progress_deploy:
            # 进程化部署未创建VM，需要在部署角色前上传安装包
            logger.info("Upload UVP package to cps-web.")
            cps_rest = FSPAuthClient.get_cps_rest_client(self.db, self.project_id, self.pod_id)
            pkg_path = os.path.dirname(self.pkg_file_path)
            pkg_file = os.path.basename(self.pkg_file_path)
            upload_obj = CpsPkgUploader(cps_rest)
            upload_obj.pkg_upload(pkg_file, pkg_path)
            logger.info("Succeed to upload UVP package[%s/%s] to cps-web." % (pkg_path, pkg_file))
        vbs_cpu = 4
        vbs_memory = 7
        logger.info('Start config and install role for node%s' % compute_ip_list)
        self.operate.config_and_deploy_role(compute_id_list, vbs_cpu, vbs_memory)

        logger.info('Checking FusionStorage-Agent rpm package')
        self.operate.check_fusionstorage_agent_rpm(self.vbs_list)

    def cleanup(self):
        vbs_bmc_ip_list = [vbs.get('bmc_ip') for vbs in self.vbs_list]
        vbs_host_id_list, vbs_host_ip_list = self.cps_host_client.get_host_info(vbs_bmc_ip_list)
        cps_client = FSPAuthClient.get_cps_rest_client(self.db, self.project_id, self.pod_id)
        logger.info("Stop fusionstorage-blockXXX role nodes%s" % str(vbs_host_ip_list))
        self.operate.stop_fusionstorage_block_template(cps_client, vbs_host_id_list)
        logger.info("Cleaning up fusionstorage-blockXXX role nodes%s" % str(vbs_host_ip_list))
        self.operate.remove_fusionstorage_block_role(cps_client, vbs_host_id_list)
        logger.info("Checking fusionstorage-blockXXX role nodes%s" % str(vbs_host_ip_list))
        self.operate.check_fusionstorage_block_on_host(cps_client, vbs_host_id_list)
