# -*- coding: utf-8 -*-
"""
Storage 上传软件包
"""
import utils.common.log as logger
from plugins.DistributedStorage.Upgrade.scripts.impl.TC_Distributed_Pkg \
    import DistributePkg
from plugins.DistributedStorage.utils.common.upgrade_base import \
    UpgradeBaseInterface


class IPkgDistribute(UpgradeBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id):
        super(IPkgDistribute, self).__init__(project_id, pod_id,
                                             az_mode="manager", reuse_mode="new", dc="master")
        self.error_code = 626090

    def run(self, project_id, pod_id):
        """
        Perform an upgrade task
        """
        logger.info('Start distribute package.')
        DistributePkg(project_id, pod_id, self.fs_args).procedure()

    def retry_run(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message对象
        """
        logger.info('Retry distribute package.')
        DistributePkg(project_id, pod_id, self.fs_args).procedure()
