# -*- coding: utf-8 -*-
"""
Storage 升级任务
"""
import utils.common.log as logger
from plugins.DistributedStorage.Upgrade.scripts.impl.TC_Upgrade_Pkg import \
    UpgradePkg
from plugins.DistributedStorage.utils.common.upgrade_base import \
    UpgradeBaseInterface


class IPkgUpgrade(UpgradeBaseInterface):
    """
    Packege Upgrade class
    """
    def __init__(self, project_id, pod_id):
        super(IPkgUpgrade, self).__init__(project_id, pod_id,
                                          az_mode="manager", reuse_mode="new", dc="standby")
        self.error_code = 626090

    def run(self, project_id, pod_id):
        """
        Perform an upgrade task
        """
        logger.info('Start packege upgrade task.')
        UpgradePkg(project_id, pod_id, self.fs_args).procedure()

    def retry_run(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message对象
        """
        logger.info('Retry packege upgrade retry task.')
        UpgradePkg(project_id, pod_id, self.fs_args).retry()
