# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.Deploy.scripts.PreCheck.implement.Job_Disk_Check import DiskCheck
from utils.common.exception import HCCIException
from utils.DBAdapter.DBConnector import BaseOps


class CheckCacheIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            all_bmc_data = self.db.get_install_os_list_info(self.pod_id)
            disk_check = DiskCheck(project_id, pod_id)
            disk_check.check_storage_node_cache_disk(all_bmc_data)
        except HCCIException as e1:
            return Message(500, e1)
        except Exception as e2:
            return Message(500, e2)
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
