# -*- coding: utf-8 -*-
import traceback

import utils.common.log as logger
from utils.business.project_condition_utils import get_project_condition_boolean
from plugins.DistributedStorage.utils.common.generalQuery import GeneralQuery
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import HCCIException
from utils.constant.FCDConstant import REGION_CONTROL_HA_AZ


class CreateFSMResourceCheck(object):
    """
    创建FSM虚拟机所需的物理节点资源检查
    """

    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()

    def check(self):
        control_az_ha_condition = get_project_condition_boolean(
            self.project_id,
            '(RegionConHA|CSHAStorage)&TenantStorFB80&(ExpansionPOD_KVM|'
            'ExpansionPOD_BMS|ExpansionAZ_KVM|ExpansionServiceStorage|ExpansionAZ_BMS)')
        if control_az_ha_condition:
            availability_zone = REGION_CONTROL_HA_AZ.DR_MANAGE_AZ
            available_list = GeneralQuery.select_host_of_fsm(
                self.db,
                self.project_id,
                self.pod_id,
                availability_zone
            )
        else:
            available_list = GeneralQuery.select_host_of_fsm(self.db, self.project_id, self.pod_id)
        logger.info("The avaliable list is {}".format(available_list))

    def procedure(self):
        try:
            self.check()
        except HCCIException as e1:
            logger.error(traceback.format_exc())
            raise e1
        except Exception as e2:
            logger.error(traceback.format_exc())
            raise e2
