# -*- coding: utf-8 -*-

from utils.common import message
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import TestCase
from plugins.DistributedStorage.Replication.scripts.common_utils.config_params import Params
from plugins.DistributedStorage.utils.common.DeployConstant import DeployConstant
from plugins.DistributedStorage.Replication.scripts.common_utils.RestOperate import RestOperate


class Install_CreateClient(TestCase):
    def __init__(self, project_id, pod_id, ip_list=None):
        super(Install_CreateClient, self).__init__(project_id, pod_id, step_id=None, metadata=None)
        self.service_name = "FusionStorageBlockReplication"
        self.ip_list = ip_list
        self.lld_dict = Params(self.project_id, self.pod_id, self.service_name).get_params_dict()
        self.fsa_ip_list = self.lld_dict.get("replication_cluster")
        self.fsm_float_ip = self.lld_dict.get("local_storage_fsm_ip")
        self.cmd_password = self.lld_dict.get('local_admin_password')
        self.opr = RestOperate(self.fsm_float_ip)

    def pre_check(self):
        # 查询client安装情况
        res = self.opr.query_dsware_client()
        succ_node_list = res.get_dsware_client_list()
        # 过滤已安装节点
        for fsa_info in succ_node_list:
            if fsa_info in self.fsa_ip_list:
                self.fsa_ip_list.remove(fsa_info)

    def procedure(self):
        try:
            logger.info("[FSBR]Get info from config_param begin.")
            self.opr.login(DeployConstant.DM_LOGIN_USER, self.cmd_password)

            logger.info("[FSBR]Get info from config_param end.")
            log_module_name = self.args_dict['log_module_name']
            logger.init(log_module_name)

            # 检查管理集群
            logger.info('[FSBR]Create Client: begin to check cluster...')
            res = self.opr.query_manage_cluster()
            manage_cluster_name = res.get_manage_cluster_name()
            if manage_cluster_name:
                logger.info('[FSBR]Create Client: check cluster successfully...')
            else:
                logger.error('[FSBR]Create Client: check cluster fail...')
                raise Exception("[FSBR]Create Client: check cluster fail...")
            logger.info('[FSBR]Create Client: check cluster end')

            # 检查资源池
            logger.info('[FSBR]Create Client: begin to check storage pool...')
            res = self.opr.query_storage_pool()
            storage_pool_name = res.get_storage_pool_name()
            if storage_pool_name:
                logger.info('[FSBR]Create Client: check storage pool successfully...')
            else:
                logger.error('[FSBR]Create Client: check storage pool fail...')
                raise Exception("[FSBR]Create Client: check storage pool fail...")

            # 开始创建客户端,检查待装列表里面是否有已经装好的，过滤掉。
            self.pre_check()
            if len(self.fsa_ip_list) == 0:
                logger.info('[FSBR]Create Client: create client successfully...')
                self.opr.login_out(DeployConstant.DM_LOGIN_USER, self.cmd_password)
                return message.Message(200)

            # create client
            logger.info('[FSBR]Create Clien: begin to create client...')
            res = self.opr.create_dsware_client(self.fsa_ip_list)
            dsware_client_count = res.get_dsware_client_count()
            logger.info('[FSBR]Create Clien:  Create client end. details: %s' % res.res.json())
            if dsware_client_count > 0:
                logger.info('[FSBR]Create Client: create client successfully...')
                self.opr.login_out(DeployConstant.DM_LOGIN_USER, self.cmd_password)
                return message.Message(200)
            else:
                logger.info('[FSBR]Create Client: create client fail.%s ' % res.res.json())
                raise Exception('[FSBR]reate Client: create client fail.%s ' % res.res.json())
        except HCCIException as e:
            msg = "Create client fail %s" % str(e)
            logger.error(msg)
            return message.Message(500, msg)
        except Exception as e:
            logger.error(e)
            return message.Message(500, HCCIException(627127, str(e)))
