# -*- coding: utf-8 -*-
import utils.common.log as logger
from utils.common.exception import HCCIException
from plugins.DistributedStorage.common.UpgradeOperate import UpgradeOperate
from plugins.DistributedStorage.common.base import TestCase
import traceback


class AlarmCheck(TestCase):
    def __init__(self, project_id, pod_id, fs_args, condition=None,
                 metadata=None, **kwargs):
        super(AlarmCheck, self).__init__(project_id, pod_id)
        self.condition = condition
        self.metadata = metadata
        self.more_args = kwargs
        self.opr = UpgradeOperate(fs_args)
        self.user_name = fs_args["user_name"]
        self.password = fs_args["password"]

    def procedure(self):
        logger.info('Start alarm check task.')
        try:
            fail_results = []
            status_code, error_code, error_des = self.opr.try_login(
                self.user_name, self.password)
            if status_code != 200 or error_code != 0:
                err_msg = "Failed to login deploy manager, " \
                          "Detail:[status:%s,code:%s]%s"\
                          % (status_code, error_code, error_des)
                logger.error(err_msg)
                raise Exception(err_msg)

            logger.info('alarm check.')
            alarm_status = "level::6 and alarmStatus::1"
            ret_result, ret_data = self.opr.get_alarm_count(alarm_status)
            if ret_result["code"] != 0:
                err_msg = "check critical alarm failed, " \
                          "Detail:[result:%s, data:%s]" \
                          % (ret_result, ret_data)
                logger.error(err_msg)
                raise Exception(err_msg)
            critical_alarm_count = ret_data["count"]
            if critical_alarm_count != 0:
                err_msg = "Critical alarm (count: %s) uncleared" \
                          % critical_alarm_count
                fail_results.append(err_msg)

            alarm_status = "level::5 and alarmStatus::1"
            ret_result, ret_data = self.opr.get_alarm_count(alarm_status)
            if ret_result["code"] != 0:
                err_msg = "check major alarm failed, " \
                          "Detail:[result:%s, data:%s]" \
                          % (ret_result, ret_data)
                logger.error(err_msg)
                raise Exception(err_msg)
            major_alarm_count = ret_data["count"]
            if major_alarm_count != 0:
                err_msg = "Major alarm (count: %s) uncleared" \
                          % major_alarm_count
                fail_results.append(err_msg)

            if fail_results:
                raise HCCIException(621005, str(fail_results))

        except HCCIException as e:
            logger.error('check alarm error,details:{}'.format(e))
            logger.error(traceback.format_exc())
            raise e
        except Exception as e:
            logger.error('check alarm error,details:{}'.format(e))
            logger.error(traceback.format_exc())
            raise HCCIException(621005, str(e))
