# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorageReplication.scripts.Testcase.fs_13_CreateHyperDomain import Domain
from utils.common.message import Message


class CreateDomain(StepBaseInterface):

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Manager，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        return Domain(project_id, pod_id).run()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return Domain(project_id, pod_id).run()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
