# -*- coding: utf-8 -*-
"""
Storage 升级前检查
"""
import utils.common.log as logger
from utils.common.message import Message
from utils.common.fic_base import StepBaseInterface
from utils.common.exception import FCUException
from plugins.DistributedStorage.basic.scripts.impl.TC_Check_Server import ServersCheck
from plugins.DistributedStorage.common.ParameterGain import ParamsGain


class PreCheck(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(PreCheck, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id, regionid_list).get_args(suit_id)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start pre upgrade server check.')
        try:
            ServersCheck(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error('check server failed')
            return Message(500, e)
        except Exception as e:
            logger.error('check server failed')
            return Message(500, FCUException(621005, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
