#!/usr/bin/env python
# -*- coding: UTF-8 -*-


"""
功    能: 设置常量

版权信息: 华为技术有限公司，版权所有(C) 2022-2025

修改记录: 2024/03/22 15:00 created

"""
import os
# SoftWare Version
VERSION = "--------------------- Version 100.001.015 For 2024.05.015 11:00:00 -------------------"
DFSROOT = os.path.dirname(os.path.dirname(__file__))


# 进度管理状态和服务接口返回状态
class ReturnStatus:
    SUCCESS = "success"
    FAIL = "failure"
    RUNNING = "executing"


# Special Disk Firmware Upgrade Parameters
SPECIAL_DISK_UPGRADE_PARAMS = {
    "GG4ZT240S3CN6SP": {
        "active": "PowerOff",
        "currentFW": ("F3C1T102", "F3C1T104"),
        "fragment": "32768"
    },
    "GG4ZT480S3CN6SP": {
        "active": "PowerOff",
        "currentFW": ("F3C1T102", "F3C1T104"),
        "fragment": "32768"
    }
}

CONFIGURATION = {
    # 上下电
    "poweroff": [
        ("GG4ZT240S3CN6SP", "F3C1T102"),
        ("GG4ZT240S3CN6SP", "F3C1T104"),
        ("GG4ZT480S3CN6SP", "F3C1T102"),
        ("GG4ZT480S3CN6SP", "F3C1T104")
    ],
    # 只支持chunk 分片
    "special_fragement": {
        # ("model_number", "firmware"): "fragement_size"
        # -- 代表为 整个model系列都按此标准 标准盘
        ("GG4ZT240S3CN6SP", "F3C1T102"): 32768,
        ("GG4ZT240S3CN6SP", "F3C1T104"): 32768,
        ("GG4ZT480S3CN6SP", "F3C1T102"): 32768,
        ("GG4ZT480S3CN6SP", "F3C1T104"): 32768
    }

    # 升级模式 立即激活 稍后激活

    # 命令模式 pio-数据分片（默认） dma-整个固件下发

    # HDD 供货盘 定制盘  其他产商-标准盘（现网盘）
}
