#!/usr/bin/python
# -*- coding: UTF-8 -*-

"""
功    能:
Raid卡的信息配置文件
版权信息: 华为技术有限公司，版权所有(C) 2019-2025
修改记录: 2024/2/29 created
"""


class RaidMap(object):
    LSI_2308 = {
        "raid_name": "2308",
        "raid_vendor": "LSI",
        "raid_tool": "sas2ircu",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    LSI_3008IR = {
        "raid_name": "3008IR",
        "raid_vendor": "LSI",
        "raid_tool": "sas3ircu",
        "support_drive_version_list": ("37.00.00.00", "27.00.00.00", "32.00.00.00", "26.100.00.00"),
        "support_firmware_list": ("14.00.00.00", "1.0.0", "15.00.07.00")
    }
    LSI_3008IT = {
        "raid_name": "3008IT",
        "raid_vendor": "LSI",
        "raid_tool": "sas3ircu",
        "support_drive_version_list": ("37.00.00.00", "27.00.00.00", "32.00.00.00", "26.100.00.00"),
        "support_firmware_list": ("14.00.00.00", "1.0.0", "15.00.07.00")
    }
    LSI_SAS2208 = {
        "raid_name": "SAS2208",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    LSI_SAS3108 = {
        "raid_name": "SAS3108",  # 扣卡
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.714.04.00", "07.720.04.00", "07.713.02.00", "07.720.04.00"),
        "support_firmware_list": ("4.680.00-8376", "4.680.00-8454", "4.680.00-8376", "1.0.0")
    }
    LSI_SAS3108_JBOD = {
        "raid_name": "3108_JBOD",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.714.04.00", "07.720.04.00", "07.713.02.00", "07.720.04.00",
                                       "07.723.02.00"),
        "support_firmware_list": ("4.680.00-8376", "4.680.00-8454", "4.680.00-8376", "1.0.0")
    }
    LSI_9361_8i = {
        "raid_name": "9361-8i",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    LSI_9364_8i = {
        "raid_name": "9364-8i",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    LSI_9361_8i_JBOD = {
        "raid_name": "9361-8i_JBOD",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    SAS3004iMR = {
        "raid_name": "SAS3004iMR",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    SAS3416iMR = {
        "raid_name": "SAS3416iMR",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.709.08.00", "07.713.02.00", "07.714.04.00", "07.716.01.00",
                                       "07.720.04.00", "07.706.03.00-rc1", "07.716.01.00"),
        "support_firmware_list": ("5.160.01-3415", "5.060.01-2262")
    }
    SAS3416IT = {
        "raid_name": "SAS3416IT",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.709.08.00", "07.713.02.00", "07.714.04.00", "07.716.01.00",
                                       "07.720.04.00", "07.706.03.00-rc1", "07.716.01.00"),
        "support_firmware_list": ("5.160.01-3415", "5.060.01-2262")
    }
    SAS3408IT = {
        "raid_name": "SAS3408IT",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.709.08.00", "07.713.02.00", "07.714.04.00", "07.720.04.00",
                                       "07.706.03.00-rc1", "07.713.02.00"),
        "support_firmware_list": ("5.160.01-3415", "5.060.01-2262", "5.140.01-3408", "5.090.01-2089", "5.140.01-3319")
    }
    SAS3408iMR = {
        "raid_name": "SAS3408iMR",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.709.08.00", "07.713.02.00", "07.714.04.00", "07.720.04.00",
                                       "07.706.03.00-rc1"),
        "support_firmware_list": ("5.160.01-3415", "5.060.01-2262")
    }
    LSI_SAS3508 = {
        "raid_name": "SAS3508",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.709.08.00", "07.713.02.00", "07.714.04.00", "07.720.04.00",
                                       "07.706.03.00-rc1", "07.720.04.00", "07.713.02.00"),
        "support_firmware_list": ("5.140.00-3515", "5.060.00-2262", "5.140.00-3408", "5.140.00-3515", "5.230.00-3767",
                                  "5.090.00-2089", "5.130.00-3059")
    }
    LSI_SAS3508_JBOD = {
        "raid_name": "SAS3508_JBOD",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.709.08.00", "07.713.02.00", "07.714.04.00", "07.720.04.00",
                                       "07.706.03.00-rc1", "07.720.04.00", "07.713.02.00"),
        "support_firmware_list": ("5.140.00-3515", "5.060.00-2262", "5.140.00-3408", "5.140.00-3515", "5.230.00-3767",
                                  "5.090.00-2089", "5.130.00-3059")
    }
    SAS3516MR = {
        "raid_name": "SAS3516MR",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    SAS3516_JBOD = {
        "raid_name": "SAS3516_JBOD",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    SAS_9440_8i = {
        "raid_name": "9440-8i",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.709.08.00", "07.713.02.00", "07.714.04.00", "07.720.04.00",
                                       "07.706.03.00-rc1", "07.713.02.00"),
        "support_firmware_list": ("5.140.01-3408", "5.090.01-2089", "5.140.01-3319")
    }
    SAS_9460_8i = {
        "raid_name": "9460-8i",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.706.03.00-rc1", "07.720.04.00", "07.713.02.00"),
        "support_firmware_list": ("5.230.00-3767", "5.090.00-2089", "5.140.00-3408", "5.130.00-3059")
    }
    SAS_9460_16i = {
        "raid_name": "9460-16i",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.719.04.00", "07.720.04.00"),
        "support_firmware_list": ("5.200.02-3681", "5.190.02-3581", "")
    }
    SAS_9460_8i_JBOD = {
        "raid_name": "9460-8i_JBOD",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.706.03.00-rc1", "07.720.04.00", "07.713.02.00"),
        "support_firmware_list": ("5.230.00-3767", "5.090.00-2089", "5.140.00-3408", "5.130.00-3059")
    }
    SAS_9460_16i_JBOD = {
        "raid_name": "9460-16i_JBOD",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    PM8060 = {
        "raid_name": "8060",
        "raid_vendor": "PMC",
        "raid_tool": "arcconf",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    PM8222 = {
        "raid_name": "8222",
        "raid_vendor": "PMC",
        "raid_tool": "arcconf",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    MSCC_SmartRAID_3152_8i = {
        "raid_name": "3152-8i",
        "raid_vendor": "PMC",
        "raid_tool": "arcconf",
        "support_drive_version_list": ("1.1.4-130", "2.1.20"),
        "support_firmware_list": ("2.93[0]")
    }
    MSCC_SmartHBA_2100_8i = {
        "raid_name": "2100-8i",
        "raid_vendor": "PMC",
        "raid_tool": "arcconf",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    MSCC_SmartHBA_2100_16i = {
        "raid_name": "2100-16i",
        "raid_vendor": "PMC",
        "raid_tool": "arcconf",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }
    PM8204 = {
        "raid_name": "8204",
        "raid_vendor": "PMC",
        "raid_tool": "arcconf",
        "support_drive_version_list": ("2.1.22-040"),
        "support_firmware_list": ("5.91")
    }
    Hi1880_RAID = {
        "raid_name": "1880_RAID",
        "raid_vendor": "Huawei",
        "raid_tool": "hiraidadm",
        "support_drive_version_list": ("1.0.1.9", "1.0.1.5", "1.0.1.6", "1.0.1.8"),
        "support_firmware_list": ("1.3.13.2", "1.3.11.5", "1.3.11.8", "1.3.11.11", "1.3.11.15", "1.3.11.19", "1.3.12.0")
    }

    Hi1880_HBA = {
        "raid_name": "1880_HBA",
        "raid_vendor": "Huawei",
        "raid_tool": "hiraidadm",
        "support_drive_version_list": ("1.0.1.9", "1.0.1.8"),
        "support_firmware_list": ("1.3.13.2", "1.3.11.15", "1.3.11.19", "1.3.12.0", "1.3.13.2")
    }

    SAS_9560_8i = {
        "raid_name": "9560-8i",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": ("07.723.02.00", "07.719.04.00", "07.720.04.00"),
        "support_firmware_list": ("5.200.02-3681", "5.190.02-3581")
    }

    SAS_9560_16i = {
        "raid_name": "9560-16i",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }

    SAS_9540_8i = {
        "raid_name": "9540-8i",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }

    HBA_9500_16i = {
        "raid_name": "9500-16i",
        "raid_vendor": "LSI",
        "raid_tool": "storcli64",
        "support_drive_version_list": (),
        "support_firmware_list": ()
    }

    raid_parameter_info = {
        "LSI_2308": [["1000", "0087", "1000", "0087"]],     # 2308 扣卡
        "LSI_3008IR": [["1000", "0097", "1000", "3090"]],   # 3008 扣卡/标卡
        "LSI_3008IT": [["1000", "0097", "1000", "30e0"]],   # 3008 扣卡/标卡
        "LSI_SAS2208": [["1000", "005b", "19e5", "d205"],   # 扣卡
                        ["1000", "005b", "19e5", "d206"]],  # 扣卡
        "LSI_SAS3108": [["1000", "005d", "19e5", "d207"],  # 扣卡
                        ["1000", "005d", "19e5", "d210"],  # 扣卡
                        ["1000", "005d", "19e5", "d20f"]],  # 扣卡
        "LSI_SAS3108_JBOD": [["1000", "005d", "19e5", "da07"]],
        "LSI_9361_8i": [["1000", "005d", "1000", "9361"]],  # 标卡
        "LSI_9364_8i": [["1000", "005d", "1000", "9364"]],  # 标卡
        "LSI_9361_8i_JBOD": [["1000", "005d", "1000", "9a61"]],  #
        "SAS3004iMR": [["1000", "005f", "19e5", "d223"]],   # 扣卡
        "SAS3408iMR": [["1000", "0017", "19e5", "d213"]],   # 3408扣卡
        "SAS3416iMR": [["1000", "0015", "19e5", "d214"]],   # 3416扣卡
        "LSI_SAS3508": [["1000", "0016", "19e5", "d215"]],  # 3508扣卡/标卡
        "SAS3516MR": [["1000", "0014", "19e5", "d216"]],    # 标卡
        "SAS3408IT": [["1000", "00af", "19e5", "d225"]],    # 扣卡
        "SAS3416IT": [["1000", "00ac", "19e5", "3000"]],    # 扣卡
        "LSI_SAS3508_JBOD": [["1000", "0016", "19e5", "da15"]],
        "SAS3516_JBOD": [["1000", "0014", "19e5", "da16"]],
        "SAS_9440_8i": [["1000", "0017", "1000", "9440"]],  # 3408标卡
        "SAS_9460_8i": [["1000", "0016", "1000", "9461"]],  # 3508标卡
        "SAS_9460_16i": [["1000", "0014", "1000", "9460"]],  # 3908标卡
        "SAS_9460_8i_JBOD": [["1000", "0016", "1000", "9a61"]],
        "SAS_9460_16i_JBOD": [[["1000", "0014", "1000", "9a60"]]],
        "PM8060": [["9005", "028d", "9005", "0555"]],   # 扣卡
        "PM8222": [["9005", "028f", "19e5", "d229"],    #
                   ["9005", "028f", "1cc4", "0201"]],   # 标卡
        "MSCC_SmartHBA_2100_8i": [["9005", "028f", "9005", "0900"]],  # 标卡
        "MSCC_SmartHBA_2100_16i": [["9005", "028f", "9005", "1282"]],  # 标卡
        "MSCC_SmartRAID_3152_8i": [["9005", "028f", "9005", "0801"]],   # 标卡
        "PM8204": [["9005", "028f", "19e5", "d228"],
                   ["9005", "028f", "19e5", "d22c"],
                   ["9005", "028f", "1cc4", "0101"]],    # 3152标卡 FBGF-RAD-R1-S1
        #                 vendor_id,system_id,sub_vendor_id,sub_system_id
        "Hi1880_RAID": [['19e5', '3758', '19e5', '0185'],   # SP686C-M-40i/SP686C-M-16i 标卡
                        ['19e5', '3758', '19e5', '01a4'],   # SP686C-M-40i/SP686C-M-16i
                        ['19e5', '3758', '19e5', '01a8'],   # SP686C-M-40i/SP686C-M-16i
                        ['19e5', '3758', '19e5', '01a1'],   # SP686C-M-40i/SP686C-M-16i
                        ['19e5', '3758', '19e5', '01ad'],   # SP686C-M-40i/SP686C-M-16i
                        ['1e81', '2200', '1e81', '0185'],
                        ['1e81', '2200', '1e81', '01a4'],
                        ['1e81', '2200', '1e81', '01a8'],
                        ['1e81', '2200', '1e81', '01a1'],
                        ['1e81', '2200', '1e81', '01ad']],
        "Hi1880_HBA": [['19e5', '3858', '19e5', '0188'],    # 1880HBA标卡
                       ['19e5', '3858', '19e5', '0180'],    # 1880HBA标卡
                       ['19e5', '3858', '19e5', '0120'],    # 1880HBA标卡
                       ['19e5', '3858', '19e5', '0125'],    # 1880HBA标卡
                       ['1e81', '2100', '1e81', '0188'],
                       ['1e81', '2100', '1e81', '0180'],
                       ['1e81', '2100', '1e81', '0120'],
                       ['1e81', '2100', '1e81', '0125']],
        "SAS_9560_8i": [["1000", "10e2", "1000", "4010"],   # 标卡
                        ["1000", "0010", "1000", "4010"]],
        "SAS_9560_16i": [["1000", "10e2", "1000", "4000"]],  # 标卡
        "SAS_9540_8i": [["1000", "10e6", "1000", "40d5"]],  # 标卡
        "HBA_9500_16i": [["1000", "00e6", "1000", "4050"]],
    }


# lspci -x

IR_RAID_TOOL_LIST = ["sas2ircu", "sas3ircu"]
