#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
功    能: 程序入口

版权信息: 华为技术有限公司，版权所有(C) 2022-2025

修改记录: 2024/3/1 9:00 created

"""
import os
import sys
import threading
import traceback

from config.constants import VERSION
from lib.exception.dfs_exception import DFSException
from lib.service import Service
from lib.utils.command import cmd_line_parse


def main():
    p = cmd_line_parse()
    args = p.parse_args()
    show_version = args.version
    if show_version:
        print(VERSION)
        return
    action = args.operation
    if not (action in ("internalLog", "internalLogProg", "upgradeProg", "smart", "upgrade", "disks")):
        raise DFSException("Error input, unsupported action")
    sn = args.sn
    model = args.model
    fw = args.fw
    task_id = args.tid
    storage_dir = args.directory
    sn = sn.split(",") if sn else []
    model = model.split(",") if model else []
    fw = fw.split(",") if fw else []
    svc = Service(filter_sn=sn, filter_model=model, filter_fw=fw, log_storage_dir=storage_dir)
    if action == "internalLog":
        svc.internal_log()
    elif action == "smart":
        svc.smart()
    elif action == "upgrade":
        svc.upgrade_firmware()
    elif action == "internalLogProg":
        svc.internal_progress(task_id=task_id)
    elif action == "upgradeProg":
        svc.get_upgrade_process()
    elif action == "disks":
        svc.get_all_disk()


if __name__ == "__main__":
    try:
        main()
    except KeyboardInterrupt:
        pass
    except SystemExit:
        raise
    except:
        traceback.print_exc()
    finally:
        if threading.active_count() > 1:
            os._exit(getattr(os, "_exitcode", 0))
        else:
            sys.exit(getattr(os, "_exitcode", 0))