#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
功    能: 自定义异常基类

版权信息: 华为技术有限公司，版权所有(C) 2022-2025

修改记录: 2022/10/10 10:00 created

"""

from lib.utils.log import SingleLog

log = SingleLog()


class DFSException(Exception):
    """
    自定义异常基类，所有异常继承此异常

    Args:
        msg (str): 自定义提示信息，默认值None

    Returns:
        DFSException 实例

    """

    def __init__(self, msg=None):
        super(DFSException, self).__init__()
        if msg:
            self.message = msg
            log.error(msg)

    def __str__(self):
        """
        重写object.__str__方法，对象转字符串
        """
        return self.message
