#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
功    能: 参数校验

版权信息: 华为技术有限公司，版权所有(C) 2022-2025

修改记录: 2022/9/12 18:00 created

"""
from lib.exception.dfs_exception import DFSException


class ValidateUtil(object):

    @staticmethod
    def validate_param(**types):
        def validate_param_types(function):
            arg_count = function.__code__.co_argcount
            for var_name in function.__code__.co_varnames:
                if var_name == "self":
                    arg_count -= 1
            if len(types) != arg_count:
                raise DFSException("The %s() need %s parameters, "
                                   "but %s parameters are obtained." %
                                   (function.__code__.co_name, len(types),
                                    arg_count))

            def check_type(*args, **kwargs):
                for index, var in enumerate(args):
                    _type = types.get(function.__code__.co_varnames[index])
                    if _type and not isinstance(var, _type):
                        raise DFSException(
                            "Parameter %s type error. %s is required." % (
                                var, _type))
                for key, var in kwargs.items():
                    _type = types.get(key)
                    if _type and not isinstance(var, _type):
                        raise DFSException(
                            "Parameter %s type error. %s is required." % (
                                var, _type))
                return function(*args, **kwargs)

            return check_type

        return validate_param_types

    @staticmethod
    def check_status_code(ret):
        """
        检查wrapper执行是否成功
        Args:
            ret: {"status_code": "0", "output": {}}

        Raises:
            result (bool)
        """

        if ret.get("status_code") != "0":
            raise DFSException("Exec wrapper Failed! return info: %s" % ret.get("output"))
        return True
