# -*- coding: utf-8 -*-
"""
Storage 升级后检查是否需要注册同意密管理
"""
from plugins.DistributedStorage.common.ParameterGain import ParamsGain
from plugins.DistributedStorage.basic.scripts.impl.TC_Install_ICAgent import InstallICAgent
from plugins.DistributedStorage.basic.scripts.impl.TC_Reg_Account_To_Unify_Pwd import RegAccountToUnifyPwd
from plugins.DistributedStorage.common.constants import UnifyPwdInfo
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.business.unite_password.unite_pwd_api import UnitePwdApi
from utils.common.message import Message
import utils.common.log as logger


COMPONENT_NAME = UnifyPwdInfo.COMPONENT_NAME
SUB_COMPONENT_NAME = UnifyPwdInfo.SUB_COMPONENT_NAME


class RegUnifyPwd(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(RegUnifyPwd, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id,
                                  regionid_list).get_args(suit_id)
        self.fs_args['region_id'] = regionid_list[0]
        self.fs_args['component_name'] = COMPONENT_NAME
        self.fs_args['sub_component_name'] = SUB_COMPONENT_NAME

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：注册统一密码管理
        :param project_id:
        :param pod_id:
        :param regionid_list:
        :return:Message类对象
        """
        logger.info("Strat to register unified passwd management")
        try:
            fsm_ips = [self.fs_args.get("master_ip"), self.fs_args.get("slaver_ip")]
            unreg_ip = self.get_dynamic_param(project_id,
                                              self.fs_args.get('region_id'), fsm_ips)
            if not unreg_ip:
                logger.info("No need to register unified passwd management.")
                return Message(200)
            logger.info("Host [%s] need to register unified passwd management." % unreg_ip)
            self.fs_args["fsm_list"] = unreg_ip
            InstallICAgent(project_id, pod_id, self.fs_args).run()
            RegAccountToUnifyPwd(project_id, pod_id, self.fs_args).run()
            return Message(200)
        except FCUException as e:
            logger.error(e)
            return Message(500, e)
        except Exception as e:
            logger.error(e)
            return Message(500, e)
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)

    @staticmethod
    def get_dynamic_param(project_id, region_id, fsm_ips):
        """
        查询当前集群fsm节点是否需要注册统一密码管理
        param project_id:
        param region_id:
        param fsm_ips:
        return unreg_ip:需要注册的ip
        """
        unite_pwd_api = UnitePwdApi(project_id)
        account_list = [('fsadmin', 1), ('root', 1)]
        unreg_ip = []
        try:
            for ip in fsm_ips:
                accounts_info = unite_pwd_api.get_account_info(
                    region_id, account_list, '', COMPONENT_NAME,
                    SUB_COMPONENT_NAME, ip)
                if not accounts_info.get('data'):
                    unreg_ip.append(ip)
            return unreg_ip
        except Exception as e:
            err_msg = "Failed to obtain the dynamic params, Detail: %s" % e
            logger.error(err_msg)
            raise Exception(err_msg)
