# -*- coding: utf-8 -*-
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import HCCIException
from plugins.DistributedStorage.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.Expansion.scripts.BusinessNewSeparate.implement.tc_install_role import InstallRole


class RemoveRoleIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = dict()
        self.fs_args['uvp_install_path'] = ParamsGain(project_id, pod_id, self.db).get_pkg_path('uvp')
        self.install_role = InstallRole(self.project_id, self.pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        try:
            self.install_role.cleanup()
        except HCCIException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, HCCIException(626115, str(e)))
        try:
            self.install_role.unregister_cloud_agent()
        except HCCIException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, HCCIException(626115, str(e)))
        return Message()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
