#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils.common.exception import HCCIException
import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.Replication.scripts.implement.fs_10_create_rep_cls_psk\
    import CreateRepClsPSKOne


class CreateRepClsPSK(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：创建控制集群，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            CreateRepClsPSKOne(project_id, pod_id).procedure()
        except HCCIException as e:
            logger.error(e)
            return Message(500, str(e))
        except Exception as e:
            logger.error(e)
            return Message(500, HCCIException(627138, str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
