#!/usr/bin/env python
# -*- coding: utf-8 -*-
import traceback
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.Deploy.scripts.BusinessSeparate.implement.tc_install_driver import InstallDriver
from plugins.DistributedStorage.Replication.scripts.common_utils.config_params import Params


class InstallDriverInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.service_name = "FusionStorageBlockReplication"
        parameters = Params(self.project_id, self.pod_id, self.service_name)
        self.fs_args = parameters.get_rep_fsa_params()

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：安装rpm依赖包，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            InstallDriver(project_id, pod_id, self.fs_args, process="rep").procedure()
        except HCCIException as e:
            logger.error("Failed install driver, details: %s" % str(e))
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error("Failed install driver, details: %s" % str(e))
            logger.error(traceback.format_exc())
            return Message(500, HCCIException(626109, str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
