# -*- coding: utf-8 -*-

from utils.business.param_util import ParamUtil
from utils.business.project_condition_utils import get_project_condition_boolean
from utils.DBAdapter.DBConnector import BaseOps
import utils.common.log as logger


class FSComConfig(object):
    """
    对外提供FusionStorage公共参数
    """
    def __init__(self, project_id, pod_id, storage_type=None):
        self.project_id = project_id
        self.pod_id = pod_id
        self.storage_type = storage_type
        self.params = ParamUtil()
        self.db = BaseOps()

    def get_fs8_fsm_float_ip(self):
        """
        返回float_ip，如果不存在，返回空
        :param: pod_id
        :return:
        """
        logger.info("Gain FusionStorage Parameters[projectID:%s,podID:%s,"
                    "storage_type:%s]" % (self.project_id, self.pod_id, self.storage_type))
        if get_project_condition_boolean(self.project_id, 'ManageStorFB80&ProjectDeploy') and \
                self.storage_type == "manage":
            logger.info("Get ManageStorFB80 Parameters")
            om_float_ip = self.params.get_value_from_cloudparam(self.pod_id, "DistributedStorageManage",
                                                                "FSMOMFloatingIP")
        elif get_project_condition_boolean(self.project_id, '(TenantStorFB80|TenantStorFBHCI80)&ProjectDeploy') and \
                self.storage_type == "business":
            logger.info("Get (TenantStorFB80|TenantStorFBHCI80)&ProjectDeploy Parameters")
            om_float_ip = self.params.get_value_from_cloudparam(self.pod_id, "DistributedStorageBusiness",
                                                                "FSMOMFloatingIP02")
        elif get_project_condition_boolean(self.project_id, 'TenantStorFB80&(ExpansionAZ_KVM|ExpansionAZ_BMS)'):
            logger.info("Get TenantStorFB80&(ExpansionAZ_KVM|ExpansionAZ_BMS) Parameters")
            om_float_ip = self.db.get_user_input_cloud_param_by_key(self.project_id, "expansion_new_fsm_float_ip")
        elif get_project_condition_boolean(self.project_id, 'TenantStorFB80&ExpansionServiceStorage'):
            logger.info("Get TenantStorFB80&ExpansionServiceStorage Parameters")
            om_float_ip = self.db.get_user_input_cloud_param_by_key(self.project_id, "expansion_fusionstorage_float_ip")
        elif get_project_condition_boolean(self.project_id, 'TenantStorFBReuse80&(ExpansionAZ_KVM)'):
            logger.info("Get TenantStorFBReuse80&(ExpansionAZ_KVM) Parameters")
            om_float_ip = self.db.get_user_input_cloud_param_by_key(self.project_id, "expansion_az_fsm_float_ip")
        elif get_project_condition_boolean(self.project_id, 'TenantStorFBReuse80&(ExpansionAZ_BMS)'):
            logger.info("Get TenantStorFBReuse80&(ExpansionAZ_BMS) Parameters")
            om_float_ip = self.db.get_user_input_cloud_param_by_key(self.project_id, "reuse_fsm_float_ip")
        else:
            logger.info("Get other Parameters")
            om_float_ip = None
        logger.info("Returned FusionStorage floatIP[%s]" % (om_float_ip))
        return om_float_ip

    def get_fs8_fsm_root_pwd(self):
        """
        返回root_pwd，如果不存在，返回空
        :param: pod_id
        :return:
        """
        logger.info("Gain FusionStorage Parameters[projectID:%s,"
                    "podID:%s,storage_type:%s]" % (self.project_id, self.pod_id, self.storage_type))
        if get_project_condition_boolean(self.project_id, 'ManageStorFB80|TenantStorFB80|TenantStorFBHCI80'):
            logger.info("Get ManageStorFB80|TenantStorFB80|TenantStorFBHCI80 Parameters")
            root_pwd = self.db.get_value_from_cloudparam(self.pod_id, "DistributedStorage", "FSMrootPassword")
        elif get_project_condition_boolean(self.project_id,
                                           'TenantStorFB80&(ExpansionAZ_KVM|ExpansionServiceStorage|ExpansionAZ_BMS)'):
            logger.info("Get TenantStorFB80&(ExpansionAZ_KVM|ExpansionServiceStorage|ExpansionAZ_BMS) Parameters")
            root_pwd = self.db.get_value_from_cloudparam(self.pod_id, "DistributedStorage", "FSMrootPassword")
        elif get_project_condition_boolean(self.project_id, 'TenantStorFBReuse80&(ExpansionAZ_KVM|ExpansionAZ_BMS)'):
            logger.info("Get TenantStorFBReuse80&(ExpansionAZ_KVM|ExpansionAZ_BMS) Parameters")
            root_pwd = self.db.get_user_input_cloud_param_by_key(self.project_id, "reuse_fsm_admin_passwd")
        else:
            logger.info("Get other Parameters")
            root_pwd = self.db.get_value_from_cloudparam(self.pod_id, "DistributedStorage", "FSMrootPassword")
        return root_pwd

    def get_fs8_fsm_dsware_pwd(self):
        """
        返回dsware_pwd，如果不存在，返回空
        :param: pod_id
        :return:
        """
        logger.info("Gain FusionStorage Parameters[projectID:%s,"
                    "podID:%s,storage_type:%s]" % (self.project_id, self.pod_id, self.storage_type))
        if get_project_condition_boolean(self.project_id, 'ManageStorFB80|TenantStorFB80|TenantStorFBHCI80'):
            logger.info("Get ManageStorFB80|TenantStorFB80|TenantStorFBHCI80 Parameters")
            dsware_pwd = self.db.get_value_from_cloudparam(self.pod_id, "DistributedStorage", "FSdswarePassword")
        elif get_project_condition_boolean(self.project_id,
                                           'TenantStorFB80&(ExpansionAZ_KVM|ExpansionServiceStorage|ExpansionAZ_BMS)'):
            logger.info("Get TenantStorFB80&(ExpansionAZ_KVM|ExpansionServiceStorage|ExpansionAZ_BMS) Parameters")
            dsware_pwd = self.db.get_value_from_cloudparam(self.pod_id, "DistributedStorage", "FSdswarePassword")
        elif get_project_condition_boolean(self.project_id, 'TenantStorFBReuse80&(ExpansionAZ_KVM|ExpansionAZ_BMS)'):
            logger.info("Get TenantStorFBReuse80&(ExpansionAZ_KVM|ExpansionAZ_BMS) Parameters")
            dsware_pwd = self.db.get_user_input_cloud_param_by_key(self.project_id, "reuse_fsm_dsware_passwd")
        else:
            logger.info("Get other Parameters")
            dsware_pwd = self.db.get_value_from_cloudparam(self.pod_id, "DistributedStorage", "FSdswarePassword")
        return dsware_pwd

    def getDswareToolPasswd(self):
        """
        返回Type1/2/3指定DswareToolPassword，如果不存在，返回空
        :param: pod_id
        :return:
        """
        logger.info("Get FusionStorage getDswareToolPassword")
        return self.db.get_value_from_cloudparam(self.pod_id, "DistributedStorage", "FSMPortalPassword")

    def getFSMdswarePassword(self):
        """
        返回Type1/2/3指定FSMdswarePassword，如果不存在，返回空
        :param: pod_id
        :return:
        """
        logger.info("Get FusionStorage FSMdswarePassword")
        return self.db.get_value_from_cloudparam(self.pod_id, "DistributedStorage", "FSdswarePassword")

    def getFSMrootPassword(self):
        """
        返回Type1/2/3指定FSMrootPassword，如果不存在，返回空
        :param: pod_id
        :return:
        """
        logger.info("Get FusionStorage FSMrootPassword")
        return self.db.get_value_from_cloudparam(self.pod_id, "DistributedStorage", "FSMrootPassword")

    def getFSMOMFloatingIP02(self):
        """
        返回Type2/3分离部署指定FSMOMFloatingIP02，如果不存在，返回空
        :param: pod_id
        :return:
        """
        logger.info("Get FusionStorage FSMOMFloatingIP02")
        om_float_ip = self.params.get_value_from_cloudparam(self.pod_id, "DistributedStorageBusiness",
                                                            "FSMOMFloatingIP02")
        return om_float_ip
