# -*- coding:utf-8 -*-
import traceback
import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import FCDException
from utils.DBAdapter.DBConnector import BaseOps
from plugins.DistributedStorage.scripts.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.scripts.implement.tc_storage_node_install_os import InstallOS


class InstallOSIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id

        self.db = BaseOps()
        fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_install_os_args()
        self.install_os = InstallOS(self.project_id, self.pod_id, fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.install_os.procedure()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            logger.error("install os failed:%s" % str(e))
            return Message(500, FCDException(626025, str(e)))
        return Message()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.install_os.reset_status()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, str(e))
        except Exception as e:
            logger.error(traceback.format_exc())
            logger.error("Rollback failed:%s" % str(e))
            return Message(500, FCDException(626081, str(e)))
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        try:
            self.install_os.procedure()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, str(e))
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, FCDException(626081, str(e)))
        return Message()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def _get_nic_mode(self, lld_key):
        nic_mode = self.db.get_user_input_cloud_param_by_key(self.project_id, lld_key)
        logger.info("Get nic mode:%s" % nic_mode)
        if nic_mode == 'active_standby':
            bond_mode = 1
        elif nic_mode == 'lacp':
            bond_mode = 4
        else:
            bond_mode = 1
        logger.info("bond mode:%s" % bond_mode)
        return bond_mode
