/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.PrintWriter;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.internal.tool.EventPrintWriter;

final class XMLWriter
extends EventPrintWriter {
    public XMLWriter(PrintWriter printWriter) {
        super(printWriter);
    }

    @Override
    protected void printBegin() {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.println("<recording xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        this.indent();
        this.printIndent();
        this.println("<events>");
        this.indent();
    }

    @Override
    protected void printEnd() {
        this.retract();
        this.printIndent();
        this.println("</events>");
        this.retract();
        this.println("</recording>");
    }

    @Override
    protected void print(List<RecordedEvent> list) {
        for (RecordedEvent recordedEvent : list) {
            this.printEvent(recordedEvent);
        }
    }

    private void printEvent(RecordedEvent recordedEvent) {
        EventType eventType = recordedEvent.getEventType();
        this.printIndent();
        this.print("<event");
        this.printAttribute("type", eventType.getName());
        this.print(">");
        this.println();
        this.indent();
        for (ValueDescriptor valueDescriptor : recordedEvent.getFields()) {
            this.printValueDescriptor(valueDescriptor, this.getValue(recordedEvent, valueDescriptor), -1);
        }
        this.retract();
        this.printIndent();
        this.println("</event>");
        this.println();
    }

    private void printAttribute(String string, String string2) {
        this.print(" ", string, "=\"", string2, "\"");
    }

    public void printObject(RecordedObject recordedObject) {
        this.println();
        this.indent();
        for (ValueDescriptor valueDescriptor : recordedObject.getFields()) {
            this.printValueDescriptor(valueDescriptor, this.getValue(recordedObject, valueDescriptor), -1);
        }
        this.retract();
    }

    private void printArray(ValueDescriptor valueDescriptor, Object[] objectArray) {
        this.println();
        this.indent();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof RecordedFrame) || n < this.getStackDepth()) {
                this.printValueDescriptor(valueDescriptor, objectArray[i], i);
            }
            ++n;
        }
        this.retract();
    }

    private void printValueDescriptor(ValueDescriptor valueDescriptor, Object object, int n) {
        String string;
        boolean bl = n != -1;
        String string2 = string = bl ? null : valueDescriptor.getName();
        if (valueDescriptor.isArray() && !bl) {
            if (this.printBeginElement("array", string, object, n)) {
                this.printArray(valueDescriptor, (Object[])object);
                this.printIndent();
                this.printEndElement("array");
            }
            return;
        }
        if (!valueDescriptor.getFields().isEmpty()) {
            if (this.printBeginElement("struct", string, object, n)) {
                this.printObject((RecordedObject)object);
                this.printIndent();
                this.printEndElement("struct");
            }
            return;
        }
        if (this.printBeginElement("value", string, object, n)) {
            this.printEscaped(String.valueOf(object));
            this.printEndElement("value");
        }
    }

    private boolean printBeginElement(String string, String string2, Object object, int n) {
        this.printIndent();
        this.print("<", string);
        if (string2 != null) {
            this.printAttribute("name", string2);
        }
        if (n != -1) {
            this.printAttribute("index", Integer.toString(n));
        }
        if (object == null) {
            this.printAttribute("xsi:nil", "true");
            this.println("/>");
            return false;
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            this.printAttribute("size", Integer.toString(objectArray.length));
        }
        this.print(">");
        return true;
    }

    private void printEndElement(String string) {
        this.print("</");
        this.print(string);
        this.println(">");
    }

    private void printEscaped(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.printEscaped(string.charAt(i));
        }
    }

    private void printEscaped(char c) {
        if (c == '\"') {
            this.print("&quot;");
            return;
        }
        if (c == '&') {
            this.print("&amp;");
            return;
        }
        if (c == '\'') {
            this.print("&apos;");
            return;
        }
        if (c == '<') {
            this.print("&lt;");
            return;
        }
        if (c == '>') {
            this.print("&gt;");
            return;
        }
        if (c > '\u007f') {
            this.print("&#");
            this.print((int)c);
            this.print(';');
            return;
        }
        this.print(c);
    }
}

